/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.item.crafting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;

public class AntiRainRocketRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private ItemStack resultItem = ItemStack.field_190927_a;
    private static final String NBT_ANTIRAIN = "ANTIRAIN";
    private final List<Item> validItems = Arrays.asList(Items.field_151152_bP, WaterworksItems.firework_anti_rain, Item.func_150898_a((Block)Blocks.field_150360_v));

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        this.resultItem = ItemStack.field_190927_a;
        int rocketStack = -1;
        int isFireworks = 0;
        int isAntiRainRocket = 0;
        int multiplierAdd = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            Item item;
            ItemStack stack = inv.func_70301_a(i);
            if (this.validateStack(stack, item = stack.func_77973_b())) {
                return false;
            }
            if (item == Items.field_151152_bP) {
                ++isFireworks;
            }
            if (item == WaterworksItems.firework_anti_rain) {
                ++isAntiRainRocket;
            }
            if (item == Items.field_151152_bP || item == WaterworksItems.firework_anti_rain) {
                rocketStack = i;
                continue;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150360_v)) continue;
            ++multiplierAdd;
        }
        if (isAntiRainRocket + isFireworks > 1 || multiplierAdd == 0) {
            return false;
        }
        this.resultItem = new ItemStack(WaterworksItems.firework_anti_rain);
        if (isFireworks > 0) {
            return this.handleFireworksRocket(inv, rocketStack, multiplierAdd);
        }
        if (isAntiRainRocket > 0) {
            return this.handleAntiRainRocket(inv, rocketStack, multiplierAdd);
        }
        return false;
    }

    protected boolean validateStack(ItemStack stack, Item item) {
        return !stack.func_190926_b() && !this.validItems.contains(item);
    }

    protected boolean handleFireworksRocket(InventoryCrafting inv, int rocketStack, int multiplierAdd) {
        boolean multiplierOld = false;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        NBTTagCompound nbtCompound = rocket.func_77978_p();
        if (nbtCompound == null) {
            nbtCompound = new NBTTagCompound();
        }
        if (0 + multiplierAdd > WaterworksConfig.rockets.clearSkyMaxMultiplier) {
            return false;
        }
        nbtCompound.func_74768_a(NBT_ANTIRAIN, 0 + multiplierAdd);
        this.resultItem.func_77982_d(nbtCompound);
        return true;
    }

    protected boolean handleAntiRainRocket(InventoryCrafting inv, int rocketStack, int multiplierAdd) {
        int multiplierOld = 0;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        NBTTagCompound nbtCompound = rocket.func_77978_p();
        NBTTagCompound newTag = new NBTTagCompound();
        if (nbtCompound != null) {
            newTag = nbtCompound.func_74737_b();
            if (nbtCompound.func_74764_b(NBT_ANTIRAIN)) {
                multiplierOld = nbtCompound.func_74762_e(NBT_ANTIRAIN);
            }
        }
        if (multiplierOld + multiplierAdd > WaterworksConfig.rockets.clearSkyMaxMultiplier) {
            return false;
        }
        newTag.func_74768_a(NBT_ANTIRAIN, multiplierOld + multiplierAdd);
        this.resultItem.func_77982_d(newTag);
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.resultItem.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.resultItem;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }
}

