/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class EnergyPacket
implements IMessage {
    private TileEntityGroundwaterPump tileEntity = null;
    BlockPos tileEntityPosition = null;
    int energyAmount = 0;

    public EnergyPacket() {
    }

    public EnergyPacket(TileEntityGroundwaterPump tileEntity) {
        this.tileEntity = tileEntity;
        this.tileEntityPosition = this.tileEntity.func_174877_v();
        this.energyAmount = this.tileEntity.getBattery().getEnergyStored();
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.energyAmount = buf.readInt();
        this.tileEntityPosition = new BlockPos(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileEntityPosition.func_177958_n());
        buf.writeInt(this.tileEntityPosition.func_177956_o());
        buf.writeInt(this.tileEntityPosition.func_177952_p());
        buf.writeInt(this.energyAmount);
    }

    public BlockPos getPos() {
        return this.tileEntityPosition;
    }

    public static class Handler
    implements IMessageHandler<EnergyPacket, IMessage> {
        public IMessage onMessage(EnergyPacket message, MessageContext ctx) {
            EntityPlayer player = Waterworks.proxy.getClientEntityPlayer();
            TileEntityGroundwaterPump pump = Handler.getTileEntity(player.field_70170_p, message.getPos());
            if (pump != null) {
                pump.getBattery().setEnergyAmount(message.energyAmount);
            }
            return null;
        }

        public static TileEntityGroundwaterPump getTileEntity(World worldObj, BlockPos pos) {
            if (worldObj == null) {
                return null;
            }
            TileEntity te = worldObj.func_175625_s(pos);
            if (te instanceof TileWaterworks) {
                return (TileEntityGroundwaterPump)te;
            }
            return null;
        }
    }
}

