/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TankPacket
implements IMessage {
    private TileWaterworks tileEntity = null;
    BlockPos tileEntityPosition = null;
    int fluidAmount = 0;
    String fluidName = null;

    public TankPacket() {
    }

    public TankPacket(TileWaterworks tileEntity) {
        this.tileEntity = tileEntity;
        this.tileEntityPosition = this.tileEntity.func_174877_v();
        this.fluidAmount = this.tileEntity.getFluidTank().getFluidAmount();
        FluidStack fluidStack = tileEntity.getFluidTank().getFluid();
        if (this.fluidAmount > 0 && fluidStack != null && fluidStack.getFluid() != null) {
            this.fluidName = fluidStack.getFluid().getName();
        }
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.fluidAmount = buf.readInt();
        if (this.fluidAmount > 0) {
            this.fluidName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.tileEntityPosition = new BlockPos(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileEntityPosition.func_177958_n());
        buf.writeInt(this.tileEntityPosition.func_177956_o());
        buf.writeInt(this.tileEntityPosition.func_177952_p());
        buf.writeInt(this.fluidAmount);
        if (this.fluidAmount > 0) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fluidName);
        }
    }

    public BlockPos getPos() {
        return this.tileEntityPosition;
    }

    public static class Handler
    implements IMessageHandler<TankPacket, IMessage> {
        public IMessage onMessage(TankPacket message, MessageContext ctx) {
            EntityPlayer player = Waterworks.proxy.getClientEntityPlayer();
            TileWaterworks tileEntity = Handler.getTileEntity(player.field_70170_p, message.getPos());
            if (tileEntity == null) {
                return null;
            }
            if (message.fluidAmount > 0) {
                tileEntity.getFluidTank().setFluid(FluidHelper.getFluidResource(message.fluidName, message.fluidAmount));
            } else {
                tileEntity.getFluidTank().setFluid(null);
            }
            return null;
        }

        public static TileWaterworks getTileEntity(World worldObj, BlockPos pos) {
            if (worldObj == null) {
                return null;
            }
            TileEntity te = worldObj.func_175625_s(pos);
            if (te instanceof TileWaterworks) {
                return (TileWaterworks)te;
            }
            return null;
        }
    }
}

