/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.proxy;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.terpo.waterworks.api.constants.EnumItemMaterials;
import org.terpo.waterworks.entity.item.EntityFireworkRocketAntiRain;
import org.terpo.waterworks.entity.item.EntityFireworkRocketRain;
import org.terpo.waterworks.entity.item.RenderFireworkRocketAntiRain;
import org.terpo.waterworks.entity.item.RenderFireworkRocketRain;
import org.terpo.waterworks.init.WaterworksBlocks;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.proxy.CommonProxy;
import org.terpo.waterworks.tileentity.TileEntityRainTankWood;
import org.terpo.waterworks.tileentity.specialrenderer.TileEntityWaterRenderer;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public EntityPlayer getClientEntityPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemRenders();
        ClientProxy.registerBlockRenders();
        ClientProxy.registerEntityRenders();
    }

    public static void registerBlockRenders() {
        if (WaterworksConfig.register.woodenRainTank) {
            ClientProxy.registerBlockRender(WaterworksBlocks.rainTankWood);
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRainTankWood.class, (TileEntitySpecialRenderer)new TileEntityWaterRenderer());
        }
        if (WaterworksConfig.register.waterPipe) {
            ClientProxy.registerBlockRender(WaterworksBlocks.waterPipe);
        }
        if (WaterworksConfig.register.rainCollectorMultiblock) {
            ClientProxy.registerBlockRender(WaterworksBlocks.rainCollector);
            ClientProxy.registerBlockRender(WaterworksBlocks.rainCollectorController);
        }
        if (WaterworksConfig.register.groundwaterPump) {
            ClientProxy.registerBlockRender(WaterworksBlocks.groundwaterPump);
        }
    }

    public static void registerBlockRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    public static void registerItemRenders() {
        ClientProxy.registerItemRender(WaterworksItems.pipe_wrench);
        if (WaterworksConfig.register.rainRocket) {
            ClientProxy.registerItemRender(WaterworksItems.firework_rain);
        }
        if (WaterworksConfig.register.antiRainRocket) {
            ClientProxy.registerItemRender(WaterworksItems.firework_anti_rain);
        }
        ClientProxy.registerItemRenderMaterials(WaterworksItems.materials);
    }

    public static void registerItemRender(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void registerItemRenderMaterials(Item item) {
        for (int i = 0; i < EnumItemMaterials.VALUES.length; ++i) {
            ResourceLocation loc = item.getRegistryName();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(loc + "_" + (Object)((Object)EnumItemMaterials.VALUES[i]), "inventory"));
        }
    }

    public static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler(EntityFireworkRocketRain.class, (IRenderFactory)new RenderFireworkRocketRain.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFireworkRocketAntiRain.class, (IRenderFactory)new RenderFireworkRocketAntiRain.Factory());
    }
}

