/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.proxy;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.gui.GuiProxy;
import org.terpo.waterworks.init.InitBlocks;
import org.terpo.waterworks.init.InitEntities;
import org.terpo.waterworks.init.InitItems;
import org.terpo.waterworks.init.InitModCompat;
import org.terpo.waterworks.init.InitTileEntities;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksCrafting;
import org.terpo.waterworks.network.WaterworksPacketHandler;

@Mod.EventBusSubscriber
public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        InitModCompat.init("pre");
        WaterworksPacketHandler.registerMessages();
    }

    public void init(FMLInitializationEvent event) {
        InitModCompat.init("init");
        WaterworksCrafting.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Waterworks.instance, (IGuiHandler)new GuiProxy());
    }

    public void postInit(FMLPostInitializationEvent event) {
        WaterworksConfig.verifyFluidNameConfig();
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        InitBlocks.initBlocks(event);
        InitTileEntities.init();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        InitBlocks.initItemBlocks(event);
        InitItems.init(event);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        InitEntities.init(event);
    }

    public EntityPlayer getClientEntityPlayer() {
        return null;
    }
}

