/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import org.terpo.waterworks.compat.bedrockbgone.BBGCompatibility;
import org.terpo.waterworks.energy.WaterworksBattery;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.helper.PumpItemStackHandler;
import org.terpo.waterworks.init.WaterworksBlocks;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.network.EnergyPacket;
import org.terpo.waterworks.network.WaterworksPacketHandler;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TileEntityGroundwaterPump
extends TileWaterworks {
    private static final String NBT_BOOLEAN_STRUCTURE_COMPLETE = "structureComplete";
    private static final String NBT_INT_PIPE_COUNTER = "pipeCounter";
    private static final String NBT_INT_ENERGY_USAGE = "energyUsage";
    private static final int PUMP_INVENTORY_SLOTS = 5;
    private static final int PIPE_INVENTARY_SLOT_START = 2;
    protected FluidStack resourceWater = null;
    private int pipeCounter = 1;
    private boolean structureComplete = false;
    private WaterworksBattery battery;
    private int energyUsage;

    public TileEntityGroundwaterPump() {
        this(WaterworksConfig.pump.groundwaterPumpFillrate, WaterworksConfig.pump.groundwaterPumpCapacity);
    }

    public TileEntityGroundwaterPump(int fillrate, int capacity) {
        super(5, capacity);
        this.battery = new WaterworksBattery(WaterworksConfig.pump.groundwaterPumpEnergyCapacity, WaterworksConfig.pump.groundwaterPumpEnergyInput, 0, this);
        this.energyUsage = WaterworksConfig.pump.groundwaterPumpEnergyBaseUsage + WaterworksConfig.pump.groundwaterPumpEnergyPipeMultiplier * this.pipeCounter;
        this.resourceWater = FluidHelper.getFluidResource(WaterworksConfig.pump.groundwaterPumpFluidName, fillrate);
        this.fluidTank.setCanFill(false);
        this.fluidTank.setTileEntity(this);
        this.itemStackHandler = new PumpItemStackHandler(this.inventorySize, this);
        this.itemStackHandler.setInputFlagForIndex(0, true);
        this.itemStackHandler.setOutputFlagForIndex(1, true);
        this.itemStackHandler.setInputFlagForIndex(2, true);
        this.itemStackHandler.setInputFlagForIndex(3, true);
        this.itemStackHandler.setInputFlagForIndex(4, true);
    }

    @Override
    protected void updateServerSide() {
        if (this.needsUpdate(5) && this.fillFluid()) {
            this.isDirty = true;
        }
        if (this.needsUpdate(20)) {
            if (!this.structureComplete) {
                this.checkStructure();
            } else {
                if (this.needsUpdate(100)) {
                    this.checkStructure();
                }
                if (this.refill()) {
                    this.isDirty = true;
                }
            }
        }
        super.updateServerSide();
    }

    private boolean refill() {
        if (this.battery.getEnergyStored() >= this.energyUsage) {
            int filled = this.fluidTank.fillInternal(this.resourceWater, true);
            if (filled == WaterworksConfig.pump.groundwaterPumpFillrate) {
                return this.battery.extractInternal(this.energyUsage, false) > 0;
            }
            if (filled > 0) {
                int energy = this.energyUsage * Math.round((float)filled / (float)WaterworksConfig.pump.groundwaterPumpFillrate);
                return this.battery.extractInternal(energy, false) > 0;
            }
        }
        return false;
    }

    public boolean shouldRefresh(World worldIn, BlockPos posIn, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private void checkStructure() {
        int count = 0;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o() - 1;
        int z = this.field_174879_c.func_177952_p();
        ArrayList<Block> bedrocks = new ArrayList<Block>();
        bedrocks.add(Blocks.field_150357_h);
        if (BBGCompatibility.BETTER_BEDROCK != null) {
            bedrocks.add(BBGCompatibility.BETTER_BEDROCK);
        }
        while (y >= 0) {
            BlockPos currentPos = new BlockPos(x, y, z);
            IBlockState state = this.field_145850_b.func_180495_p(currentPos);
            Block block = state.func_177230_c();
            if (block.equals(WaterworksBlocks.waterPipe)) {
                ++count;
                if (--y >= 0) continue;
            }
            if (bedrocks.contains(block) || !WaterworksConfig.pump.groundwaterPumpCheckBedrock && y < 0) {
                this.structureComplete = true;
                this.pipeCounter = count;
                this.energyUsage = WaterworksConfig.pump.groundwaterPumpEnergyBaseUsage + WaterworksConfig.pump.groundwaterPumpEnergyPipeMultiplier * this.pipeCounter;
                return;
            }
            if (block.equals(Blocks.field_150350_a) && this.battery.hasEnoughEnergy(WaterworksConfig.pump.groundwaterPumpEnergyPipePlacement) && this.placePipe(currentPos)) {
                this.battery.extractInternal(WaterworksConfig.pump.groundwaterPumpEnergyPipePlacement, false);
                break;
            }
            this.structureComplete = false;
            break;
        }
    }

    private boolean placePipe(BlockPos currentPos) {
        HashMap<ItemStack, Integer> stacks = this.getPipeStacks();
        if (!stacks.isEmpty()) {
            stacks.forEach((stack, slot) -> {
                if (this.field_145850_b.func_180501_a(currentPos, WaterworksBlocks.waterPipe.func_176223_P(), 2)) {
                    if (stack.func_190916_E() > 1) {
                        stack.func_190918_g(1);
                    } else {
                        this.itemStackHandler.setStackInSlot((int)slot, ItemStack.field_190927_a);
                    }
                    return;
                }
            });
            return true;
        }
        return false;
    }

    private HashMap<ItemStack, Integer> getPipeStacks() {
        HashMap<ItemStack, Integer> pipeStack = new HashMap<ItemStack, Integer>();
        for (int i = 2; i < this.inventorySize; ++i) {
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            pipeStack.put(stack, i);
        }
        return pipeStack;
    }

    public boolean isStructureComplete() {
        return this.structureComplete;
    }

    public void setStructureComplete(boolean structureComplete) {
        this.structureComplete = structureComplete;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.battery);
        }
        return super.getCapability(capability, facing);
    }

    public WaterworksBattery getBattery() {
        return this.battery;
    }

    public void sendEnergyPacket() {
        WaterworksPacketHandler.sendToAllAround(new EnergyPacket(this), this);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.battery.writeToNBT(compound);
        compound.func_74768_a(NBT_INT_ENERGY_USAGE, this.energyUsage);
        compound.func_74768_a(NBT_INT_PIPE_COUNTER, this.pipeCounter);
        compound.func_74757_a(NBT_BOOLEAN_STRUCTURE_COMPLETE, this.structureComplete);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.battery = this.battery.readFromNBT(compound);
        if (compound.func_74764_b(NBT_INT_ENERGY_USAGE)) {
            this.energyUsage = compound.func_74762_e(NBT_INT_ENERGY_USAGE);
        }
        if (compound.func_74764_b(NBT_INT_PIPE_COUNTER)) {
            this.pipeCounter = compound.func_74762_e(NBT_INT_PIPE_COUNTER);
        }
        if (compound.func_74764_b(NBT_BOOLEAN_STRUCTURE_COMPLETE)) {
            this.structureComplete = compound.func_74767_n(NBT_BOOLEAN_STRUCTURE_COMPLETE);
        }
    }
}

