/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.tileentity.BaseTileEntity;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;

public class TileEntityRainCollector
extends BaseTileEntity {
    private TileEntityRainCollectorController controller = null;
    private BlockPos controllerPosition = null;

    public boolean hasController() {
        if (this.controller != null) {
            return true;
        }
        return this.controllerPosition != null && this.verifyControllerPosition(this.controllerPosition);
    }

    public TileEntityRainCollectorController getController() {
        return this.controller;
    }

    public void informAboutBlockBreak() {
        if (this.hasController() && !this.controller.func_145837_r()) {
            this.controller.removeCollector(this.field_174879_c);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.hasController()) {
            BlockPos controllerPos = this.controller.func_174877_v();
            compound.func_74772_a("controllerPos", controllerPos.func_177986_g());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("controllerPos")) {
            this.controllerPosition = BlockPos.func_177969_a((long)compound.func_74763_f("controllerPos"));
        }
    }

    private boolean verifyControllerPosition(BlockPos position) {
        TileEntityRainCollectorController tileEntity;
        TileEntity tile = this.field_145850_b.func_175625_s(position);
        if (tile instanceof TileEntityRainCollectorController && (tileEntity = (TileEntityRainCollectorController)tile).isCollectorListed(this.field_174879_c)) {
            this.controller = tileEntity;
            return true;
        }
        return false;
    }

    public boolean setController(TileEntityRainCollectorController tE) {
        if (!this.hasController()) {
            this.controller = tE;
            return true;
        }
        return false;
    }

    public boolean setController(BlockPos position) {
        if (!this.hasController()) {
            return this.verifyControllerPosition(position);
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.hasController()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return true;
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasController()) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)((Object)this.controller.itemStackHandler);
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this.controller.fluidTank);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void breakConnection(TileEntityRainCollectorController otherController) {
        if (this.hasController() && this.controller.func_174877_v().equals((Object)otherController.func_174877_v())) {
            this.controller = null;
            this.controllerPosition = null;
        }
    }
}

