/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.helper.AreaHelper;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.tileentity.TileEntityRainCollector;
import org.terpo.waterworks.tileentity.TileEntityRainTankWood;

public class TileEntityRainCollectorController
extends TileEntityRainTankWood {
    private final int controllerRange;
    private final int areaCount;
    private BlockPos[] rainCollectorBlocks;
    protected int connectedCollectors;
    private boolean isReset;
    protected int validCollectors;
    private int currentValidationPos;
    private int countValidCollectors;

    public TileEntityRainCollectorController() {
        super(FluidHelper.getFluidResource(WaterworksConfig.rainCollection.rainCollectorCollectedFluidName, WaterworksConfig.rainCollection.rainCollectorFillrate), WaterworksConfig.rainCollection.rainCollectorCapacity);
        this.controllerRange = WaterworksConfig.rainCollection.rainCollectorRange;
        this.areaCount = (int)Math.pow((double)this.controllerRange * 2.0 + 1.0, 2.0);
        this.rainCollectorBlocks = new BlockPos[this.areaCount];
        this.connectedCollectors = 1;
        this.isReset = false;
        this.validCollectors = 0;
        this.currentValidationPos = 0;
        this.countValidCollectors = 0;
    }

    @Override
    protected void updateServerSide() {
        if (this.isReset && this.needsUpdate(10)) {
            this.isDirty = true;
            this.resetController();
            this.findRainCollectors();
            this.isReset = false;
        }
        if (this.needsUpdate(15) && this.field_145850_b.func_72896_J()) {
            this.countValidCollectors();
        }
        super.updateServerSide();
    }

    @Override
    protected boolean isRefilling() {
        if (this.field_145850_b.func_72896_J()) {
            this.fluidTank.fillInternal(this.fluidResource, true);
            return true;
        }
        return false;
    }

    private void countValidCollectors() {
        int maxValid = this.currentValidationPos + 5 > this.areaCount ? this.areaCount : this.currentValidationPos + 5;
        for (int i = this.currentValidationPos; i < maxValid; ++i) {
            if (this.rainCollectorBlocks[i] == null || !this.field_145850_b.func_175727_C(this.rainCollectorBlocks[i].func_177984_a())) continue;
            ++this.countValidCollectors;
        }
        this.currentValidationPos = maxValid;
        if (this.currentValidationPos == this.areaCount) {
            this.validCollectors = this.countValidCollectors;
            this.fluidResource = FluidHelper.recalculateFillrate(this.fluidResource, this.validCollectors * WaterworksConfig.rainCollection.rainCollectorFillrate, WaterworksConfig.rainCollection.rainCollectorCollectedFluidName);
            this.countValidCollectors = 0;
            this.currentValidationPos = 0;
        }
    }

    public int findRainCollectors() {
        this.resetController();
        this.connectedCollectors = this.getAllConnectedBlocks();
        this.fluidResource = FluidHelper.recalculateFillrate(this.fluidResource, this.validCollectors * WaterworksConfig.rainCollection.rainCollectorFillrate, WaterworksConfig.rainCollection.rainCollectorCollectedFluidName);
        return this.connectedCollectors;
    }

    public void debugCollectors() {
        Waterworks.LOGGER.info("Fill Multiplier @" + this.connectedCollectors);
        for (BlockPos blockPos : this.rainCollectorBlocks) {
            if (blockPos == null) continue;
            Waterworks.LOGGER.info("Collector @" + blockPos.toString());
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        int connectedBlocks = 0;
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.areaCount; ++i) {
            if (this.rainCollectorBlocks[i] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("collectorPos", this.rainCollectorBlocks[i].func_177986_g());
            list.func_74742_a((NBTBase)nbt);
            ++connectedBlocks;
        }
        compound.func_74768_a("connectedBlocks", connectedBlocks);
        compound.func_74782_a("collectorPosList", (NBTBase)list);
        compound.func_74768_a("validCollectors", this.validCollectors);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("connectedBlocks")) {
            this.connectedCollectors = compound.func_74762_e("connectedBlocks");
            if (compound.func_74764_b("collectorPosList")) {
                NBTTagList list = compound.func_150295_c("collectorPosList", 10);
                if (list.func_74745_c() > this.areaCount) {
                    this.rainCollectorBlocks = new BlockPos[list.func_74745_c()];
                    this.isReset = true;
                }
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound nbt = list.func_150305_b(i);
                    this.rainCollectorBlocks[i] = BlockPos.func_177969_a((long)nbt.func_74763_f("collectorPos"));
                }
            }
            if (compound.func_74764_b("validCollectors")) {
                this.validCollectors = compound.func_74762_e("validCollectors");
                this.fluidResource = FluidHelper.recalculateFillrate(this.fluidResource, this.validCollectors * WaterworksConfig.rainCollection.rainCollectorFillrate, WaterworksConfig.rainCollection.rainCollectorCollectedFluidName);
            }
        }
    }

    private boolean isValidBlock(BlockPos blockPos, int currentIndex) {
        boolean ret;
        TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
        boolean bl = ret = tileEntity instanceof TileEntityRainCollector && AreaHelper.isInRange2D(blockPos, this.field_174879_c, this.controllerRange);
        if (!ret) {
            return false;
        }
        if (((TileEntityRainCollector)tileEntity).hasController()) {
            return false;
        }
        if (ret) {
            for (int i = 0; i < currentIndex; ++i) {
                if (!this.rainCollectorBlocks[i].equals((Object)blockPos)) continue;
                return false;
            }
        }
        return ret;
    }

    private int getAllConnectedBlocks() {
        int foundBlockCount = 1;
        this.rainCollectorBlocks[0] = this.field_174879_c;
        for (int i = 0; i < foundBlockCount; ++i) {
            BlockPos tempPos = this.rainCollectorBlocks[i].func_177982_a(-1, 0, 0);
            if (this.isValidBlock(tempPos, foundBlockCount)) {
                this.rainCollectorBlocks[foundBlockCount++] = tempPos;
                ((TileEntityRainCollector)this.field_145850_b.func_175625_s(tempPos)).setController(this);
            }
            if (this.isValidBlock(tempPos = this.rainCollectorBlocks[i].func_177982_a(1, 0, 0), foundBlockCount)) {
                this.rainCollectorBlocks[foundBlockCount++] = tempPos;
                ((TileEntityRainCollector)this.field_145850_b.func_175625_s(tempPos)).setController(this);
            }
            if (this.isValidBlock(tempPos = this.rainCollectorBlocks[i].func_177982_a(0, 0, 1), foundBlockCount)) {
                this.rainCollectorBlocks[foundBlockCount++] = tempPos;
                ((TileEntityRainCollector)this.field_145850_b.func_175625_s(tempPos)).setController(this);
            }
            if (!this.isValidBlock(tempPos = this.rainCollectorBlocks[i].func_177982_a(0, 0, -1), foundBlockCount)) continue;
            this.rainCollectorBlocks[foundBlockCount++] = tempPos;
            ((TileEntityRainCollector)this.field_145850_b.func_175625_s(tempPos)).setController(this);
        }
        return foundBlockCount;
    }

    public void removeCollector(BlockPos collectorPos) {
        for (BlockPos blockPos : this.rainCollectorBlocks) {
            if (blockPos == null || !blockPos.equals((Object)collectorPos)) continue;
            this.isReset = true;
            return;
        }
    }

    public void resetController() {
        for (int i = 1; i < this.rainCollectorBlocks.length; ++i) {
            TileEntity tile;
            BlockPos blockPos = this.rainCollectorBlocks[i];
            if (blockPos == null || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEntityRainCollector)) continue;
            ((TileEntityRainCollector)tile).breakConnection(this);
        }
        this.rainCollectorBlocks = new BlockPos[this.areaCount];
    }

    public int getConnectedCollectors() {
        return this.connectedCollectors;
    }

    public boolean isCollectorListed(BlockPos collectorPos) {
        if (this.rainCollectorBlocks != null) {
            for (int i = 0; i < this.rainCollectorBlocks.length; ++i) {
                if (this.rainCollectorBlocks[i] == null || !this.rainCollectorBlocks[i].equals((Object)collectorPos)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

