/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TileEntityRainTankWood
extends TileWaterworks {
    protected FluidStack fluidResource = null;
    private static final int INVENTORY_SLOT_COUNT = 2;

    public TileEntityRainTankWood() {
        this(FluidHelper.getFluidResource(WaterworksConfig.rainCollection.woodenRainTankCollectedFluidName, WaterworksConfig.rainCollection.woodenRainTankFillrate), WaterworksConfig.rainCollection.woodenRainTankCapacity);
    }

    public TileEntityRainTankWood(FluidStack stack, int capacity) {
        super(2, capacity);
        this.fluidResource = stack;
        this.fluidTank.setCanFill(false);
        this.fluidTank.setTileEntity(this);
        this.itemStackHandler = new GeneralItemStackHandler(this.inventorySize, this);
        this.itemStackHandler.setInputFlagForIndex(0, true);
        this.itemStackHandler.setOutputFlagForIndex(1, true);
    }

    @Override
    protected void updateServerSide() {
        if (this.fillFluid()) {
            this.isDirty = true;
        }
        if (this.needsUpdate(20) && this.isRefilling()) {
            this.isDirty = true;
        }
        super.updateServerSide();
    }

    public boolean shouldRefresh(World worldIn, BlockPos posIn, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getStateLevel() {
        return Math.round((float)this.fluidTank.getFluidAmount() * 4.0f / (float)this.fluidTank.getCapacity());
    }

    protected boolean isRefilling() {
        BlockPos position = this.func_174877_v().func_177984_a();
        if (this.field_145850_b.func_175727_C(position)) {
            this.fluidTank.fillInternal(this.fluidResource, true);
            return true;
        }
        return false;
    }
}

