/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.network.TankPacket;
import org.terpo.waterworks.network.WaterworksPacketHandler;
import org.terpo.waterworks.tileentity.BaseTileEntity;

public class TileWaterworks
extends BaseTileEntity
implements ITickable {
    private static final Random random = new Random();
    private int currentTick = random.nextInt(256);
    protected WaterworksTank fluidTank;
    protected int inventorySize;
    protected int tankSize;
    protected GeneralItemStackHandler itemStackHandler;

    public TileWaterworks(int inventorySize, int tankSize) {
        this.inventorySize = inventorySize;
        this.tankSize = tankSize;
        this.fluidTank = new WaterworksTank(this.tankSize);
    }

    protected void sendUpdatePacket() {
        WaterworksPacketHandler.sendToAllAround(new TankPacket(this), this);
    }

    public TileWaterworks() {
        this(2, 8000);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.itemStackHandler.serializeNBT());
        this.fluidTank.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
        this.fluidTank = (WaterworksTank)this.fluidTank.readFromNBT(compound);
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.itemStackHandler);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.fluidTank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public final void func_73660_a() {
        ++this.currentTick;
        if (!this.field_145850_b.field_72995_K) {
            this.updateServerSide();
        } else {
            this.updateClientSide();
        }
    }

    protected void updateClientSide() {
    }

    protected void updateServerSide() {
        if (this.isDirty) {
            this.func_70296_d();
            this.sendUpdatePacket();
            this.isDirty = false;
        }
    }

    protected boolean needsUpdate(int tickInterval) {
        return this.currentTick % tickInterval == 0;
    }

    public int getINVSIZE() {
        return this.inventorySize;
    }

    public void setINVSIZE(int iNVSIZE) {
        this.inventorySize = iNVSIZE;
    }

    public int getTANKSIZE() {
        return this.tankSize;
    }

    public void setTANKSIZE(int tANKSIZE) {
        this.tankSize = tANKSIZE;
    }

    public int getComparatorOutput() {
        if (this.fluidTank.isEmpty()) {
            return 0;
        }
        return (int)(1.0 + (double)this.fluidTank.getFluidAmount() / (double)this.fluidTank.getCapacity() * 14.0);
    }

    public int getDebugInfo() {
        return this.fluidTank.getFluidAmount();
    }

    public WaterworksTank getFluidTank() {
        return this.fluidTank;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected boolean fillFluid() {
        ItemStack stackInput;
        int internalFluidAmount = this.fluidTank.getFluidAmount();
        if (internalFluidAmount > 0 && !(stackInput = this.itemStackHandler.getStackInSlot(0)).func_190926_b()) {
            ItemStack outputStack;
            ItemStack outputSlot;
            FluidActionResult filledSimulated;
            if (stackInput.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (filledSimulated = FluidUtil.tryFillContainer((ItemStack)stackInput, (IFluidHandler)this.fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
                FluidActionResult fillResult;
                ItemStack simResult = filledSimulated.getResult();
                ItemStack outputSlot2 = this.itemStackHandler.getStackInSlot(1);
                if (TileWaterworks.checkOutputSlot(outputSlot2, simResult) && (fillResult = FluidUtil.tryFillContainer((ItemStack)stackInput, (IFluidHandler)this.fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                    ItemStack realResult = fillResult.getResult();
                    this.moveFilledInputToOutput(stackInput, outputSlot2, realResult);
                    return true;
                }
            }
            if (stackInput.func_77973_b().equals(Items.field_151069_bo) && internalFluidAmount >= 1000 && this.fluidTank.getFluid() != null && FluidRegistry.WATER.equals(this.fluidTank.getFluid().getFluid()) && TileWaterworks.checkOutputSlot(outputSlot = this.itemStackHandler.getStackInSlot(1), outputStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b))) {
                this.fluidTank.drainInternal(1000, true);
                this.moveFilledInputToOutput(stackInput, outputSlot, outputStack);
                return true;
            }
        }
        return false;
    }

    private static boolean checkOutputSlot(ItemStack outputSlot, ItemStack stack) {
        boolean isItemIdentical = outputSlot.func_77973_b().equals(stack.func_77973_b());
        boolean hasSpace = outputSlot.func_190916_E() < outputSlot.func_77976_d();
        return outputSlot.func_190926_b() || isItemIdentical && hasSpace;
    }

    private void moveFilledInputToOutput(ItemStack stackInput, ItemStack outputSlot, ItemStack realResult) {
        if (outputSlot.func_190926_b()) {
            this.itemStackHandler.setStackInSlot(1, realResult);
        } else {
            outputSlot.func_190917_f(1);
        }
        if (stackInput.func_190916_E() > 1) {
            stackInput.func_190918_g(1);
        } else {
            this.itemStackHandler.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public int getCurrentTick() {
        return this.currentTick;
    }
}

