/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.entity.item;

import java.util.OptionalInt;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.terpo.waterworks.entity.item.EntityWeatherFireworkRocket;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksEntities;
import org.terpo.waterworks.init.WaterworksItems;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityFireworkRocketRain
extends EntityWeatherFireworkRocket
implements IRendersAsItem {
    private static final DataParameter<ItemStack> RAINROCKET_ITEM = EntityDataManager.func_187226_a(EntityFireworkRocketRain.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> BOOSTED_RAINROCKET_ENTITY_ID = EntityDataManager.func_187226_a(EntityFireworkRocketRain.class, (IDataSerializer)DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> SHOT_AT_ANGLE_RAINROCKET_BOOLEAN = EntityDataManager.func_187226_a(EntityFireworkRocketRain.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityFireworkRocketRain(EntityType<? extends EntityFireworkRocketRain> entity, World world) {
        super(entity, world);
    }

    public EntityFireworkRocketRain(World worldIn, double x, double y, double z, ItemStack itemstack) {
        super(WaterworksEntities.entityFireworkRain, worldIn, x, y, z, itemstack);
    }

    public EntityFireworkRocketRain(World worldIn, ItemStack itemstack, LivingEntity entity) {
        super(WaterworksEntities.entityFireworkRain, worldIn, itemstack, entity);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RAINROCKET_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BOOSTED_RAINROCKET_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(SHOT_AT_ANGLE_RAINROCKET_BOOLEAN, (Object)false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getRocketItem();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)WaterworksItems.itemFireworkRain) : itemstack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getAnnouncementText(int time, int days, int hours, int min) {
        return new TranslationTextComponent("entity.rain_rocket.announcement", new Object[]{time, days, hours, min}).func_150254_d();
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K) {
            WorldInfo worldInfo = this.func_130014_f_().func_72912_H();
            worldInfo.func_176142_i(0);
            worldInfo.func_76080_g(this.duration);
            worldInfo.func_76090_f(this.duration);
            worldInfo.func_76084_b(true);
            worldInfo.func_76069_a(this.field_70146_Z.nextInt(10) > 6);
        }
        super.func_70106_y();
    }

    @Override
    public boolean isShotAtAngle() {
        Boolean shotAtAngle = (Boolean)this.field_70180_af.func_187225_a(SHOT_AT_ANGLE_RAINROCKET_BOOLEAN);
        return shotAtAngle != null && shotAtAngle != false;
    }

    @Override
    public void setShotAtAngle(Boolean shotAtAngle) {
        this.field_70180_af.func_187227_b(SHOT_AT_ANGLE_RAINROCKET_BOOLEAN, (Object)shotAtAngle);
    }

    @Override
    public ItemStack getRocketItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(RAINROCKET_ITEM);
    }

    @Override
    public void setRocketItem(ItemStack givenItem) {
        this.field_70180_af.func_187227_b(RAINROCKET_ITEM, (Object)givenItem.func_77946_l());
    }

    @Override
    public OptionalInt getBoostedEntity() {
        return (OptionalInt)this.field_70180_af.func_187225_a(BOOSTED_RAINROCKET_ENTITY_ID);
    }

    @Override
    public void setBoostedEntity(LivingEntity entity) {
        this.field_70180_af.func_187227_b(BOOSTED_RAINROCKET_ENTITY_ID, (Object)OptionalInt.of(entity.func_145782_y()));
    }

    @Override
    protected int calculateDurationFromMultiplier(int rainMultiplier) {
        return WaterworksConfig.rockets.getRainDuration() * rainMultiplier;
    }

    @Override
    protected String getRocketTypeTag() {
        return "RAIN";
    }

    @Override
    protected int getConfiguredDuration() {
        return WaterworksConfig.rockets.getRainDuration();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemFromEntity() {
        return this.func_184543_l();
    }
}

