/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.entity.item;

import java.util.OptionalInt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import org.terpo.waterworks.Waterworks;

public abstract class EntityWeatherFireworkRocket
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    public static final String NBT_FIREWORKS = "Fireworks";
    public static final String NBT_SHOT_AT_ANGLE = "ShotAtAngle";
    protected int fireworkAge;
    protected int lifetime;
    protected LivingEntity boostedEntity;
    protected int duration;
    protected int durationMultiplier;

    public EntityWeatherFireworkRocket(EntityType<? extends EntityWeatherFireworkRocket> entity, World world) {
        super(entity, world);
    }

    public EntityWeatherFireworkRocket(EntityType<?> entityType, World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(entityType, worldIn);
        this.func_70107_b(x, y, z);
        this.duration = this.getConfiguredDuration();
        this.durationMultiplier = -1;
        this.fireworkAge = 0;
        int i = 1;
        if (!givenItem.func_190926_b() && givenItem.func_77942_o()) {
            this.setRocketItem(givenItem);
            i += givenItem.func_190925_c(NBT_FIREWORKS).func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
        if (givenItem.func_77942_o()) {
            CompoundNBT tag = givenItem.func_77978_p();
            if (tag.func_74764_b(this.getRocketTypeTag())) {
                this.durationMultiplier = tag.func_74762_e(this.getRocketTypeTag());
            }
            if (this.durationMultiplier != -1) {
                this.duration = this.calculateDurationFromMultiplier(this.durationMultiplier);
            }
        }
    }

    public EntityWeatherFireworkRocket(EntityType<?> entityType, World world, ItemStack itemStack, LivingEntity entity) {
        this(entityType, world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, itemStack);
        this.setBoostedEntity(entity);
        this.boostedEntity = entity;
    }

    public EntityWeatherFireworkRocket(EntityType<?> entityType, World world, ItemStack itemStack, double x, double y, double z, boolean shotAtAngle) {
        this(entityType, world, x, y, z, itemStack);
        this.setShotAtAngle(shotAtAngle);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.getRocketItem();
            CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a(NBT_FIREWORKS);
            Vec3d vec3d = this.func_213322_ci();
            this.field_70170_p.func_92088_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, compoundnbt);
        }
        super.func_70103_a(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void announceRocket(int time) {
        int days = time / 24000;
        int hours = time % 24000 / 1000;
        int min = time % 24000 % 1000 / 17;
        Waterworks.proxy.getClientPlayerEntity().func_145747_a((ITextComponent)new StringTextComponent(this.getAnnouncementText(time, days, hours, min)));
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.isAttachedToEntity()) {
            if (this.boostedEntity == null) {
                this.getBoostedEntity().ifPresent(entityId -> {
                    Entity entity = this.field_70170_p.func_73045_a(entityId);
                    if (entity instanceof LivingEntity) {
                        this.boostedEntity = (LivingEntity)entity;
                    }
                });
            }
            if (this.boostedEntity != null) {
                if (this.boostedEntity.func_184613_cA()) {
                    Vec3d vec3d = this.boostedEntity.func_70040_Z();
                    Vec3d vec3d1 = this.boostedEntity.func_213322_ci();
                    this.boostedEntity.func_213317_d(vec3d1.func_72441_c(vec3d.field_72450_a * 0.1 + (vec3d.field_72450_a * 1.5 - vec3d1.field_72450_a) * 0.5, vec3d.field_72448_b * 0.1 + (vec3d.field_72448_b * 1.5 - vec3d1.field_72448_b) * 0.5, vec3d.field_72449_c * 0.1 + (vec3d.field_72449_c * 1.5 - vec3d1.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.boostedEntity.field_70165_t, this.boostedEntity.field_70163_u, this.boostedEntity.field_70161_v);
                this.func_213317_d(this.boostedEntity.func_213322_ci());
            }
        } else {
            if (!this.isShotAtAngle()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.15, 1.0, 1.15).func_72441_c(0.0, 0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        }
        Vec3d vec3d2 = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(vec3d2).func_186662_g(1.0), entitiy -> !entitiy.func_175149_v() && entitiy.func_70089_S() && entitiy.func_70067_L(), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (boolean)true);
        if (!this.field_70145_X) {
            this.computeRayTraceResult(raytraceresult);
            this.field_70160_al = true;
        }
        float f = MathHelper.func_76133_a((double)EntityWeatherFireworkRocket.func_213296_b((Vec3d)vec3d2));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d2.field_72450_a, (double)vec3d2.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d2.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        if (this.fireworkAge == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        if (this.field_70170_p.field_72995_K && this.fireworkAge == 0) {
            this.announceRocket(this.duration);
        }
        ++this.fireworkAge;
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 2 < 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.fireworkAge > this.lifetime) {
            this.setDead();
        }
    }

    private void setDead() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)17);
        this.dealExplosionDamage();
        this.func_70106_y();
    }

    protected void computeRayTraceResult(RayTraceResult rayTraceResult) {
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY && !this.field_70170_p.field_72995_K) {
            this.setDead();
        } else if (this.field_70132_H) {
            BlockPos blockpos = rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK ? new BlockPos((Vec3i)((BlockRayTraceResult)rayTraceResult).func_216350_a()) : new BlockPos((Entity)this);
            this.field_70170_p.func_180495_p(blockpos).func_196950_a(this.field_70170_p, blockpos, (Entity)this);
            if (this.hasExplosions()) {
                this.setDead();
            }
        }
    }

    private boolean hasExplosions() {
        ItemStack itemstack = this.getRocketItem();
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a(NBT_FIREWORKS);
        ListNBT listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        return listnbt != null && !listnbt.isEmpty();
    }

    private void dealExplosionDamage() {
        ListNBT listnbt;
        float f = 0.0f;
        ItemStack itemstack = this.getRocketItem();
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a(NBT_FIREWORKS);
        ListNBT listNBT = listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        if (listnbt != null && !listnbt.isEmpty()) {
            f = 5.0f + (float)(listnbt.size() * 2);
        }
        if (f > 0.0f) {
            if (this.boostedEntity != null) {
                this.boostedEntity.func_70097_a(DamageSource.field_191552_t, 5.0f + (float)(listnbt.size() * 2));
            }
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (livingentity == this.boostedEntity || !(this.func_70068_e((Entity)livingentity) <= 25.0)) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3d vec3d1 = new Vec3d(livingentity.field_70165_t, livingentity.field_70163_u + (double)livingentity.func_213302_cg() * 0.5 * (double)i, livingentity.field_70161_v);
                    BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                    if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d((Entity)livingentity)) / 5.0);
                livingentity.func_70097_a(DamageSource.field_191552_t, f1);
            }
        }
    }

    public boolean func_70075_an() {
        return false;
    }

    private boolean isAttachedToEntity() {
        return this.getBoostedEntity().isPresent();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70186_c(double incomingX, double incomingY, double incomingZ, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(incomingX * incomingX + incomingY * incomingY + incomingZ * incomingZ));
        double x = incomingX / (double)f;
        double y = incomingY / (double)f;
        double z = incomingZ / (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.duration);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.duration = additionalData.readInt();
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Life", this.fireworkAge);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = this.getRocketItem();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("FireworksItem", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a(NBT_SHOT_AT_ANGLE, this.isShotAtAngle());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.fireworkAge = compound.func_74762_e("Life");
        this.lifetime = compound.func_74762_e("LifeTime");
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("FireworksItem"));
        if (!itemstack.func_190926_b()) {
            this.setRocketItem(itemstack);
        }
        if (compound.func_74764_b(NBT_SHOT_AT_ANGLE)) {
            this.setShotAtAngle(compound.func_74767_n(NBT_SHOT_AT_ANGLE));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract String getAnnouncementText(int var1, int var2, int var3, int var4);

    protected abstract void func_70088_a();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ItemStack getItemFromEntity();

    protected abstract boolean isShotAtAngle();

    protected abstract void setShotAtAngle(Boolean var1);

    protected abstract ItemStack getRocketItem();

    protected abstract void setRocketItem(ItemStack var1);

    protected abstract OptionalInt getBoostedEntity();

    protected abstract void setBoostedEntity(LivingEntity var1);

    protected abstract int calculateDurationFromMultiplier(int var1);

    protected abstract String getRocketTypeTag();

    protected abstract int getConfiguredDuration();
}

