/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.init;

import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.block.BlockGroundwaterPump;
import org.terpo.waterworks.block.BlockRainCollector;
import org.terpo.waterworks.block.BlockRainCollectorController;
import org.terpo.waterworks.block.BlockRainTankWood;
import org.terpo.waterworks.block.BlockWaterPipe;
import org.terpo.waterworks.init.WaterworksBlocks;

public class InitBlocks {
    public static void initBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainTankWood(), "rain_tank_wood");
        InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockWaterPipe(), "water_pipe");
        InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainCollector(), "rain_collector");
        InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockRainCollectorController(), "rain_collector_controller");
        InitBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockGroundwaterPump(), "groundwater_pump");
    }

    public static Block registerBlock(IForgeRegistry<Block> registry, Block block, String name) {
        block.setRegistryName("waterworks", name);
        registry.register((IForgeRegistryEntry)block);
        return block;
    }

    public static void initItemBlocks(IForgeRegistry<Item> registry) {
        InitBlocks.registerItemBlock(registry, WaterworksBlocks.rainTankWood);
        InitBlocks.registerItemBlock(registry, WaterworksBlocks.waterPipe);
        InitBlocks.registerItemBlock(registry, WaterworksBlocks.rainCollector);
        InitBlocks.registerItemBlock(registry, WaterworksBlocks.rainCollectorController);
        InitBlocks.registerItemBlock(registry, WaterworksBlocks.groundwaterPump);
    }

    public static Item registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        Item item = (Item)new BlockItem(block, new Item.Properties().func_200916_a(Waterworks.CREATIVE_TAB)).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)item);
        return item;
    }

    private InitBlocks() {
    }
}

