/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.terpo.waterworks.Waterworks;

public class ItemWaterworksDebugger
extends Item {
    private static final String DRAIN_MODE = "drainMode";
    private static final String ENERGY_MODE = "energyMode";

    public ItemWaterworksDebugger() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Waterworks.CREATIVE_TAB));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_77978_p();
        tooltip.add((ITextComponent)new StringTextComponent("Right Click in Air to change between Fluid/Energy Mode"));
        tooltip.add((ITextComponent)new StringTextComponent("Sneak Right Click in Air to change between Drain/Fill Mode"));
        tooltip.add((ITextComponent)ItemWaterworksDebugger.currentMode(tag));
    }

    private static String getEnergyMode(CompoundNBT tag) {
        return tag != null && tag.func_74764_b(ENERGY_MODE) && tag.func_74767_n(ENERGY_MODE) ? "energy" : "fluid";
    }

    private static String getDrainMode(CompoundNBT tag) {
        return tag != null && tag.func_74764_b(DRAIN_MODE) && tag.func_74767_n(DRAIN_MODE) ? "drain" : "fill";
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            TileEntity tileEntity = context.func_195991_k().func_175625_s(context.func_195995_a());
            ItemStack stack = context.func_195996_i();
            if (tileEntity != null && context.func_195998_g() && !stack.func_190926_b()) {
                boolean drainMode;
                CompoundNBT tag = stack.func_77978_p();
                boolean energyMode = tag != null && tag.func_74764_b(ENERGY_MODE) && tag.func_74767_n(ENERGY_MODE);
                boolean bl = drainMode = tag != null && tag.func_74764_b(DRAIN_MODE) && tag.func_74767_n(DRAIN_MODE);
                if (energyMode) {
                    ItemWaterworksDebugger.handleEnergy(tileEntity, drainMode);
                } else {
                    ItemWaterworksDebugger.handleFluid(tileEntity, drainMode);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    private static void handleFluid(TileEntity tileEntity, boolean drainMode) {
        LazyOptional capability = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        capability.ifPresent(b -> {
            if (drainMode) {
                b.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            } else {
                b.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }

    private static void handleEnergy(TileEntity tileEntity, boolean drainMode) {
        LazyOptional capability = tileEntity.getCapability(CapabilityEnergy.ENERGY);
        capability.ifPresent(b -> {
            if (drainMode) {
                b.extractEnergy(50000, false);
            } else {
                b.receiveEnergy(50000, false);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack;
        if (!worldIn.field_72995_K && !(stack = playerIn.func_184586_b(Hand.MAIN_HAND)).func_190926_b()) {
            CompoundNBT tag = stack.func_196082_o();
            if (playerIn.func_70093_af()) {
                if (tag.func_74764_b(DRAIN_MODE)) {
                    tag.func_74757_a(DRAIN_MODE, !tag.func_74767_n(DRAIN_MODE));
                } else {
                    tag.func_74757_a(DRAIN_MODE, true);
                }
            } else if (tag.func_74764_b(ENERGY_MODE)) {
                tag.func_74757_a(ENERGY_MODE, !tag.func_74767_n(ENERGY_MODE));
            } else {
                tag.func_74757_a(ENERGY_MODE, true);
            }
            playerIn.func_145747_a((ITextComponent)ItemWaterworksDebugger.currentMode(tag));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private static StringTextComponent currentMode(CompoundNBT tag) {
        return new StringTextComponent("Mode: " + ItemWaterworksDebugger.getDrainMode(tag) + " " + ItemWaterworksDebugger.getEnergyMode(tag));
    }
}

