/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.item.crafting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.init.WaterworksRecipes;

public class AntiRainRocketRecipe
extends SpecialRecipe {
    private static final String NBT_ANTIRAIN = "ANTIRAIN";
    private ItemStack resultItem = ItemStack.field_190927_a;
    private final List<Item> validItems = Arrays.asList(Items.field_196152_dE, WaterworksItems.itemFireworkAntiRain, (Item)Item.field_179220_a.get(Blocks.field_150360_v));

    public AntiRainRocketRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        this.resultItem = ItemStack.field_190927_a;
        int rocketStack = -1;
        int isFireworks = 0;
        int isAntiRainRocket = 0;
        int multiplierAdd = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            Item item;
            ItemStack stack = inv.func_70301_a(i);
            if (this.validateStack(stack, item = stack.func_77973_b())) {
                return false;
            }
            if (item == Items.field_196152_dE) {
                ++isFireworks;
            }
            if (item == WaterworksItems.itemFireworkAntiRain) {
                ++isAntiRainRocket;
            }
            if (item == Items.field_196152_dE || item == WaterworksItems.itemFireworkAntiRain) {
                rocketStack = i;
                continue;
            }
            if (item != Item.field_179220_a.get(Blocks.field_150360_v)) continue;
            ++multiplierAdd;
        }
        if (isAntiRainRocket + isFireworks > 1 || multiplierAdd == 0) {
            return false;
        }
        this.resultItem = new ItemStack((IItemProvider)WaterworksItems.itemFireworkAntiRain);
        if (isFireworks > 0) {
            return this.handleFireworksRocket(inv, rocketStack, multiplierAdd);
        }
        if (isAntiRainRocket > 0) {
            return this.handleAntiRainRocket(inv, rocketStack, multiplierAdd);
        }
        return false;
    }

    protected boolean validateStack(ItemStack stack, Item item) {
        return !stack.func_190926_b() && !this.validItems.contains(item);
    }

    protected boolean handleFireworksRocket(CraftingInventory inv, int rocketStack, int multiplierAdd) {
        boolean multiplierOld = false;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        CompoundNBT nbtCompound = rocket.func_77978_p();
        if (nbtCompound == null) {
            nbtCompound = new CompoundNBT();
        }
        if (0 + multiplierAdd > WaterworksConfig.rockets.getClearSkyMaxMultiplier()) {
            return false;
        }
        nbtCompound.func_74768_a(NBT_ANTIRAIN, 0 + multiplierAdd);
        this.resultItem.func_77982_d(nbtCompound);
        return true;
    }

    protected boolean handleAntiRainRocket(CraftingInventory inv, int rocketStack, int multiplierAdd) {
        int multiplierOld = 0;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        CompoundNBT nbtCompound = rocket.func_77978_p();
        CompoundNBT newTag = new CompoundNBT();
        if (nbtCompound != null) {
            newTag = nbtCompound.func_74737_b();
            if (nbtCompound.func_74764_b(NBT_ANTIRAIN)) {
                multiplierOld = nbtCompound.func_74762_e(NBT_ANTIRAIN);
            }
        }
        if (multiplierOld + multiplierAdd > WaterworksConfig.rockets.getClearSkyMaxMultiplier()) {
            return false;
        }
        newTag.func_74768_a(NBT_ANTIRAIN, multiplierOld + multiplierAdd);
        this.resultItem.func_77982_d(newTag);
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.resultItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return WaterworksRecipes.recipeFireworkAntiRain;
    }
}

