/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.item.crafting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksItems;
import org.terpo.waterworks.init.WaterworksRecipes;

public class RainRocketRecipe
extends SpecialRecipe {
    private ItemStack resultItem = ItemStack.field_190927_a;
    private final List<Item> validItems = Arrays.asList(Items.field_196152_dE, WaterworksItems.itemFireworkRain, Items.field_151073_bk);

    public RainRocketRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        this.resultItem = ItemStack.field_190927_a;
        int rocketStack = -1;
        int isFireworks = 0;
        int isRainRocket = 0;
        int multiplierAdd = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            Item item;
            ItemStack stack = inv.func_70301_a(i);
            if (this.validateStack(stack, item = stack.func_77973_b())) {
                return false;
            }
            if (item == Items.field_196152_dE) {
                ++isFireworks;
            }
            if (item == WaterworksItems.itemFireworkRain) {
                ++isRainRocket;
            }
            if (item == Items.field_196152_dE || item == WaterworksItems.itemFireworkRain) {
                rocketStack = i;
                continue;
            }
            if (item != Items.field_151073_bk) continue;
            ++multiplierAdd;
        }
        if (isRainRocket + isFireworks > 1 || multiplierAdd == 0) {
            return false;
        }
        this.resultItem = new ItemStack((IItemProvider)WaterworksItems.itemFireworkRain);
        if (isFireworks > 0) {
            return this.handleFireworksRocket(inv, rocketStack, multiplierAdd);
        }
        if (isRainRocket > 0) {
            return this.handleRainRocket(inv, rocketStack, multiplierAdd);
        }
        return false;
    }

    protected boolean validateStack(ItemStack stack, Item item) {
        return !stack.func_190926_b() && !this.validItems.contains(item);
    }

    protected boolean handleRainRocket(CraftingInventory inv, int rocketStack, int multiplierAdd) {
        int multiplierOld = 0;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        CompoundNBT nbtCompound = rocket.func_77978_p();
        CompoundNBT newTag = new CompoundNBT();
        if (nbtCompound != null) {
            newTag = nbtCompound.func_74737_b();
            if (nbtCompound.func_74764_b("RAIN")) {
                multiplierOld = nbtCompound.func_74762_e("RAIN");
            }
        }
        if (multiplierOld + multiplierAdd > WaterworksConfig.rockets.getRainMaxMultiplier()) {
            return false;
        }
        newTag.func_74768_a("RAIN", multiplierOld + multiplierAdd);
        this.resultItem.func_77982_d(newTag);
        return true;
    }

    protected boolean handleFireworksRocket(CraftingInventory inv, int rocketStack, int multiplierAdd) {
        boolean multiplierOld = false;
        ItemStack rocket = inv.func_70301_a(rocketStack);
        CompoundNBT nbtCompound = rocket.func_77978_p();
        if (nbtCompound == null) {
            nbtCompound = new CompoundNBT();
        }
        if (0 + multiplierAdd > WaterworksConfig.rockets.getRainMaxMultiplier()) {
            return false;
        }
        nbtCompound.func_74768_a("RAIN", 0 + multiplierAdd);
        this.resultItem.func_77982_d(nbtCompound);
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        return this.resultItem.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return WaterworksRecipes.recipeFireworkRain;
    }
}

