/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.init.WaterworksTileEntities;
import org.terpo.waterworks.tileentity.BaseTileEntity;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;

public class TileEntityRainCollector
extends BaseTileEntity {
    private static final String NBT_CONTROLLER_POS = "controllerPos";
    private TileEntityRainCollectorController controller = null;
    private BlockPos controllerPosition = null;

    public TileEntityRainCollector() {
        super(WaterworksTileEntities.rainCollector);
    }

    public boolean hasController() {
        if (this.controller != null) {
            return true;
        }
        return this.controllerPosition != null && this.verifyControllerPosition(this.controllerPosition);
    }

    public TileEntityRainCollectorController getController() {
        return this.controller;
    }

    public void informAboutBlockBreak() {
        if (this.hasController() && !this.controller.func_145837_r()) {
            this.controller.removeCollector(this.field_174879_c);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.hasController()) {
            BlockPos controllerPos = this.controller.func_174877_v();
            compound.func_74772_a(NBT_CONTROLLER_POS, controllerPos.func_218275_a());
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_CONTROLLER_POS)) {
            this.controllerPosition = BlockPos.func_218283_e((long)compound.func_74763_f(NBT_CONTROLLER_POS));
        }
    }

    private boolean verifyControllerPosition(BlockPos position) {
        TileEntityRainCollectorController tileEntity;
        TileEntity tile = this.field_145850_b.func_175625_s(position);
        if (tile instanceof TileEntityRainCollectorController && (tileEntity = (TileEntityRainCollectorController)tile).isCollectorListed(this.field_174879_c)) {
            this.controller = tileEntity;
            return true;
        }
        return false;
    }

    public boolean setController(TileEntityRainCollectorController tE) {
        if (!this.hasController()) {
            this.controller = tE;
            return true;
        }
        return false;
    }

    public boolean setController(BlockPos position) {
        if (!this.hasController()) {
            return this.verifyControllerPosition(position);
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.hasController()) {
            return this.controller.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.hasController()) {
            return this.controller.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).cast();
        }
        return super.getCapability(capability, side);
    }

    public void breakConnection(TileEntityRainCollectorController otherController) {
        if (this.hasController() && this.controller.func_174877_v().equals((Object)otherController.func_174877_v())) {
            this.controller = null;
            this.controllerPosition = null;
        }
    }
}

