/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.gui.ContainerBase;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.init.WaterworksConfig;
import org.terpo.waterworks.init.WaterworksContainers;
import org.terpo.waterworks.init.WaterworksTileEntities;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TileEntityRainTankWood
extends TileWaterworks {
    protected FluidStack fluidResource = null;
    private static final int INVENTORY_SLOT_COUNT = 2;

    public TileEntityRainTankWood() {
        this(WaterworksTileEntities.rainTankWood, WaterworksConfig.rainCollection.getWoodenRainTankFillrate(), WaterworksConfig.rainCollection.getWoodenRainTankCapacity());
    }

    public TileEntityRainTankWood(TileEntityType<?> tileEntityTypeIn) {
        this(tileEntityTypeIn, WaterworksConfig.rainCollection.getWoodenRainTankFillrate(), WaterworksConfig.rainCollection.getWoodenRainTankCapacity());
    }

    public TileEntityRainTankWood(TileEntityType<?> tileEntityTypeIn, int fillrate, int capacity) {
        super(tileEntityTypeIn, 2, capacity);
        this.fluidResource = new FluidStack((Fluid)Fluids.field_204546_a, fillrate);
    }

    @Override
    protected GeneralItemStackHandler createItemHandler() {
        GeneralItemStackHandler handler = new GeneralItemStackHandler(this.inventorySize, this);
        handler.setInputFlagForIndex(0, true);
        handler.setOutputFlagForIndex(1, true);
        return handler;
    }

    @Override
    protected void updateServerSide() {
        if (this.fillFluid()) {
            this.isDirty = true;
        }
        if (this.needsUpdate(20) && this.isRefilling()) {
            this.isDirty = true;
        }
        super.updateServerSide();
    }

    public int getStateLevel() {
        WaterworksTank tank = this.getFluidTank();
        return Math.round((float)tank.getFluidAmount() * 4.0f / (float)tank.getCapacity());
    }

    protected boolean isRefilling() {
        BlockPos position = this.func_174877_v().func_177984_a();
        if (this.field_145850_b.func_175727_C(position)) {
            this.getFluidTank().fillInternal(this.fluidResource, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity entity) {
        return new ContainerBase(WaterworksContainers.rainTankWood, windowId, (IInventory)inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.waterworks.rain_tank_wood", new Object[0]);
    }
}

