/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.network.TankPacket;
import org.terpo.waterworks.network.WaterworksPacketHandler;
import org.terpo.waterworks.tileentity.BaseTileEntity;

public abstract class TileWaterworks
extends BaseTileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private static final String NBT_ITEMS = "items";
    private static final Random random = new Random();
    private int currentTick = random.nextInt(256);
    protected final LazyOptional<WaterworksTank> fluidTank = LazyOptional.of(this::createTank);
    protected LazyOptional<GeneralItemStackHandler> itemStackHandler = LazyOptional.of(this::createItemHandler);
    protected int inventorySize;
    protected int tankSize;

    public TileWaterworks(TileEntityType<?> tileEntityTypeIn, int inventorySize, int tankSize) {
        super(tileEntityTypeIn);
        this.inventorySize = inventorySize;
        this.tankSize = tankSize;
    }

    public TileWaterworks(TileEntityType<?> tileEntityTypeIn) {
        this(tileEntityTypeIn, 2, 8000);
    }

    protected WaterworksTank createTank() {
        return new WaterworksTank(this.tankSize, this);
    }

    protected abstract GeneralItemStackHandler createItemHandler();

    protected void sendUpdatePacket() {
        WaterworksPacketHandler.sendToAllAround(new TankPacket(this), this);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.itemStackHandler.ifPresent(handler -> compound.func_218657_a(NBT_ITEMS, (INBT)handler.serializeNBT()));
        this.fluidTank.ifPresent(tank -> tank.writeToNBT(compound));
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_ITEMS)) {
            this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.func_74775_l(NBT_ITEMS)));
        }
        this.fluidTank.ifPresent(tank -> tank.readFromNBT(compound));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemStackHandler.cast();
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidTank.cast();
        }
        return super.getCapability(capability, side);
    }

    public final void func_73660_a() {
        ++this.currentTick;
        if (!this.field_145850_b.field_72995_K) {
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
        if (this.isDirty) {
            this.func_70296_d();
            this.sendUpdatePacket();
            this.isDirty = false;
        }
    }

    protected boolean needsUpdate(int tickInterval) {
        return this.currentTick % tickInterval == 0;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    public int getComparatorOutput() {
        WaterworksTank tank = (WaterworksTank)((Object)this.fluidTank.orElseGet(this::createTank));
        if (tank.isEmpty()) {
            return 0;
        }
        return (int)(1.0 + (double)tank.getFluidAmount() / (double)tank.getCapacity() * 14.0);
    }

    public WaterworksTank getFluidTank() {
        return (WaterworksTank)((Object)this.fluidTank.orElseGet(this::createTank));
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected boolean fillFluid() {
        ItemStack stackInput;
        WaterworksTank tank = (WaterworksTank)((Object)this.fluidTank.orElseGet(this::createTank));
        GeneralItemStackHandler handler = (GeneralItemStackHandler)((Object)this.itemStackHandler.orElseGet(this::createItemHandler));
        int internalFluidAmount = tank.getFluidAmount();
        if (internalFluidAmount > 0 && !(stackInput = handler.getStackInSlot(0)).func_190926_b()) {
            if (TileWaterworks.handleFluidCapabilityItem(tank, handler, stackInput)) {
                return true;
            }
            if (stackInput.func_77973_b().equals(Items.field_151069_bo) && internalFluidAmount >= 1000 && TileWaterworks.handleGlassBottle(tank, handler, stackInput)) {
                return true;
            }
        }
        return false;
    }

    private static boolean handleFluidCapabilityItem(WaterworksTank tank, GeneralItemStackHandler handler, ItemStack stackInput) {
        FluidActionResult filledSimulated;
        LazyOptional capability = stackInput.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (capability.isPresent() && (filledSimulated = FluidUtil.tryFillContainer((ItemStack)stackInput, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
            FluidActionResult fillResult;
            ItemStack simResult = filledSimulated.getResult();
            ItemStack outputSlot = handler.getStackInSlot(1);
            if (TileWaterworks.checkOutputSlot(outputSlot, simResult) && (fillResult = FluidUtil.tryFillContainer((ItemStack)stackInput, (IFluidHandler)tank, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                ItemStack realResult = fillResult.getResult();
                TileWaterworks.moveFilledInputToOutput(stackInput, outputSlot, realResult, handler);
                return true;
            }
        }
        return false;
    }

    private static boolean handleGlassBottle(WaterworksTank tank, GeneralItemStackHandler handler, ItemStack stackInput) {
        ItemStack outputStack;
        ItemStack outputSlot = handler.getStackInSlot(1);
        if (TileWaterworks.checkOutputSlot(outputSlot, outputStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b))) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            TileWaterworks.moveFilledInputToOutput(stackInput, outputSlot, outputStack, handler);
            return true;
        }
        return false;
    }

    private static boolean checkOutputSlot(ItemStack outputSlot, ItemStack stack) {
        boolean isItemIdentical = outputSlot.func_77973_b().equals(stack.func_77973_b());
        boolean hasSpace = outputSlot.func_190916_E() < outputSlot.func_77976_d();
        return outputSlot.func_190926_b() || isItemIdentical && hasSpace;
    }

    private static void moveFilledInputToOutput(ItemStack stackInput, ItemStack outputSlot, ItemStack realResult, ItemStackHandler handler) {
        if (outputSlot.func_190926_b()) {
            handler.setStackInSlot(1, realResult);
        } else {
            outputSlot.func_190917_f(1);
        }
        if (stackInput.func_190916_E() > 1) {
            stackInput.func_190918_g(1);
        } else {
            handler.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    protected static FluidStack getWaterFluidStack(int amount) {
        return new FluidStack((Fluid)Fluids.field_204546_a, amount);
    }

    public int getCurrentTick() {
        return this.currentTick;
    }
}

