/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity.specialrenderer;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.tileentity.TileWaterworks;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityWaterRenderer
extends TileEntityRenderer<TileWaterworks> {
    int blue;
    int green;
    int red;
    int alphaValue;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void render(TileWaterworks te, double x, double y, double z, float partialTicks, int destroyStage) {
        WaterworksTank tank = te.getFluidTank();
        int amount = tank.getFluidAmount();
        int capacity = tank.getCapacity();
        FluidStack fluidStack = tank.getFluid();
        Fluid fluid = fluidStack.getFluid();
        if (fluid != null) {
            int c = fluid.getAttributes().getColor();
            this.blue = c & 0xFF;
            this.green = c >> 8 & 0xFF;
            this.red = c >> 16 & 0xFF;
            this.alphaValue = c >> 24 & 0xFF;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(fluid.getAttributes().getStillTexture());
            this.diffU = this.maxU - this.minU;
            this.diffV = this.maxV - this.minV;
            if (sprite != null) {
                double multiplier = 0.25;
                this.minU = (double)sprite.func_94209_e() + this.diffU * 0.25;
                this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.25;
                this.minV = (double)sprite.func_94206_g() + this.diffV * 0.25;
                this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.25;
                int i = this.func_178459_a().func_217338_b(te.func_174877_v(), fluid.getAttributes().getLuminosity());
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                double yFilled = 0.8125 * ((double)amount / (double)capacity);
                double startPos = 0.0625;
                double endPos = 0.9375;
                double yStartOffset = 0.125;
                GlStateManager.disableCull();
                GlStateManager.disableLighting();
                GlStateManager.enableBlend();
                GlStateManager.enableAlphaTest();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                buffer.func_181662_b(x + 0.0625, y + 0.125 + yFilled, z + 0.0625).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alphaValue).func_181675_d();
                buffer.func_181662_b(x + 0.9375, y + 0.125 + yFilled, z + 0.0625).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alphaValue).func_181675_d();
                buffer.func_181662_b(x + 0.9375, y + 0.125 + yFilled, z + 0.9375).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alphaValue).func_181675_d();
                buffer.func_181662_b(x + 0.0625, y + 0.125 + yFilled, z + 0.9375).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alphaValue).func_181675_d();
                tess.func_78381_a();
                GlStateManager.disableBlend();
                GlStateManager.enableLighting();
            }
        }
    }
}

