/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.item.ItemPipeWrench;
import org.terpo.waterworks.tileentity.BaseTileEntity;
import org.terpo.waterworks.tileentity.TileEntityRainCollector;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;

public class BlockRainCollector
extends BaseBlockTE<BaseTileEntity> {
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.rain_collector", new Object[0]));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRainCollector();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult facing) {
        BaseTileEntity tileEntity;
        if (!worldIn.field_72995_K && hand == Hand.MAIN_HAND && (tileEntity = this.getTileEntity(worldIn, pos)) instanceof TileEntityRainCollector) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            TileEntityRainCollector collector = (TileEntityRainCollector)tileEntity;
            if (heldItem.func_77973_b() instanceof ItemPipeWrench) {
                BlockRainCollector.handleRightClickWithWrench(playerIn, collector);
                return ActionResultType.SUCCESS;
            }
            if (collector.hasController()) {
                TileEntityRainCollectorController controller = collector.getController();
                if (!heldItem.func_190926_b() && !playerIn.func_225608_bj_() && controller.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, controller, heldItem)) {
                    return ActionResultType.SUCCESS;
                }
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)controller, (BlockPos)controller.func_174877_v());
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.SUCCESS;
    }

    protected static void handleRightClickWithWrench(PlayerEntity playerIn, TileEntityRainCollector collector) {
        TranslationTextComponent out;
        if (collector.hasController()) {
            BlockPos controllerPos = collector.getController().func_174877_v();
            out = new TranslationTextComponent("block.waterworks.rain_collector.has_controller", new Object[]{controllerPos.func_177958_n(), controllerPos.func_177956_o(), controllerPos.func_177952_p()});
        } else {
            out = new TranslationTextComponent("block.waterworks.rain_collector.no_controller", new Object[0]);
        }
        playerIn.func_145747_a((ITextComponent)out);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BaseTileEntity tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof TileEntityRainCollector) {
            ((TileEntityRainCollector)tileEntity).informAboutBlockBreak();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState bs) {
        return true;
    }

    public int func_180641_l(BlockState bs, World world, BlockPos pos) {
        TileEntityRainCollector collector;
        BaseTileEntity tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof TileEntityRainCollector && (collector = (TileEntityRainCollector)tileEntity).hasController()) {
            return collector.getController().getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te;
        if (player.func_225608_bj_() && (te = world.func_175625_s(data.getPos())) instanceof TileEntityRainCollector) {
            IIconStyle iconStyle = probeInfo.defaultIconStyle().textureWidth(32).textureHeight(32);
            TileEntityRainCollector tile = (TileEntityRainCollector)te;
            String tooltip = new TranslationTextComponent("tooltip.controller", new Object[0]).func_150254_d();
            if (tile.hasController()) {
                BlockPos pos = tile.getController().func_174877_v();
                probeInfo.horizontal().text(tooltip).icon(this.guiIconsTOP, 0, 16, 16, 16, iconStyle).text("@" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p());
            } else {
                probeInfo.horizontal().text(tooltip).icon(this.guiIconsTOP, 16, 16, 16, 16, iconStyle);
            }
        }
    }

    @Override
    protected BaseTileEntity getTileEntity(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        if (tE instanceof BaseTileEntity) {
            return (BaseTileEntity)tE;
        }
        return null;
    }
}

