/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.helper.WaterworksInventoryHelper;
import org.terpo.waterworks.tileentity.TileEntityRainTankWood;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class BlockRainTankWood
extends BaseBlockTE<TileWaterworks> {
    public BlockRainTankWood() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult facing) {
        TileWaterworks tileEntity;
        if (!worldIn.field_72995_K && hand == Hand.MAIN_HAND && (tileEntity = this.getTileEntity(worldIn, pos)) instanceof TileEntityRainTankWood) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (!heldItem.func_190926_b() && !playerIn.func_225608_bj_() && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).isPresent() && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, tileEntity, heldItem)) {
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)tileEntity, (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRainTankWood();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState bs) {
        return true;
    }

    public int func_180641_l(BlockState bs, World world, BlockPos pos) {
        TileWaterworks te = this.getTileEntity(world, pos);
        if (te instanceof TileWaterworks) {
            return this.getTileEntity(world, pos).getComparatorOutput();
        }
        return 0;
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity te, ItemStack stack) {
        TileWaterworks tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof TileWaterworks) {
            LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.ifPresent(handler -> WaterworksInventoryHelper.dropItemsFromInventory(world, pos, handler));
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    @Override
    protected TileWaterworks getTileEntity(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        if (tE instanceof TileWaterworks) {
            return (TileWaterworks)tE;
        }
        return null;
    }
}

