/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.gui;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.terpo.waterworks.inventory.FilteredFluidSlotItemHandler;
import org.terpo.waterworks.inventory.SlotDefinition;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class ContainerBase
extends Container {
    private final TileWaterworks tileWaterworks;

    public ContainerBase(@Nullable ContainerType<?> type, int windowId, IInventory playerInv, TileEntity te) {
        super(type, windowId);
        this.tileWaterworks = (TileWaterworks)te;
        this.tileWaterworks.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(this::addOwnSlots);
        this.addPlayerSlots(playerInv);
    }

    protected void addOwnSlots(IItemHandler handler) {
        FilteredFluidSlotItemHandler input = new FilteredFluidSlotItemHandler(handler, 0, 44, 35, SlotDefinition.I);
        FilteredFluidSlotItemHandler output = new FilteredFluidSlotItemHandler(handler, 1, 116, 35, SlotDefinition.O);
        input.addItemToFilter(Items.field_151069_bo);
        input.addItemToFilter(Items.field_151068_bn);
        this.func_75146_a((Slot)input);
        this.func_75146_a((Slot)output);
    }

    private void addPlayerSlots(IInventory playerInv) {
        int row;
        int SLOTWIDTH = 18;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 84;
                this.func_75146_a(new Slot(playerInv, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            this.func_75146_a(new Slot(playerInv, row, x, 142));
        }
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int invsize = this.tileWaterworks.getInventorySize();
            if (index < invsize ? !this.func_75135_a(itemstack1, invsize, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, invsize, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return ContainerBase.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileWaterworks.func_145831_w(), (BlockPos)this.tileWaterworks.func_174877_v()), (PlayerEntity)playerIn, (Block)this.tileWaterworks.func_195044_w().func_177230_c());
    }

    public TileWaterworks getTileWaterworks() {
        return this.tileWaterworks;
    }
}

