/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.gui.pump;

import java.util.ArrayList;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import org.terpo.waterworks.gui.ContainerBase;
import org.terpo.waterworks.gui.FluidContainerScreen;

@OnlyIn(value=Dist.CLIENT)
public class PumpContainerScreen
extends FluidContainerScreen {
    protected Rectangle2d batteryRectangle;

    public PumpContainerScreen(ContainerBase screenContainer, PlayerInventory inv, ITextComponent title) {
        super(screenContainer, inv, title);
    }

    @Override
    protected void prepare(ResourceLocation newGui, Rectangle2d newTankRectangle, ContainerBase screenContainer) {
        super.prepare(new ResourceLocation("waterworks:textures/gui/container/groundwater_pump.png"), new Rectangle2d(80, 17, 16, 52), screenContainer);
        this.batteryRectangle = new Rectangle2d(8, 17, 16, 52);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawBattery(this.batteryRectangle);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.drawBatteryTooltip(mouseX, mouseY, this.batteryRectangle);
    }

    protected void drawBattery(Rectangle2d batteryRect) {
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(battery -> {
                int fillHeight = battery.getEnergyStored() * batteryRect.func_199317_d() / battery.getMaxEnergyStored();
                this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("waterworks:textures/blocks/energy_overlay.png"));
                this.blit(this.getGuiLeft() + batteryRect.func_199318_a(), this.getGuiTop() + batteryRect.func_199319_b() + batteryRect.func_199317_d() - fillHeight, 0, 0, batteryRect.func_199316_c(), fillHeight);
            });
        }
    }

    protected void drawBatteryTooltip(int mouseX, int mouseY, Rectangle2d batteryRect) {
        if (this.tileEntity != null) {
            this.tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(battery -> {
                String tooltip = battery.getEnergyStored() + "/" + battery.getMaxEnergyStored() + " RF";
                if (this.getGuiLeft() + batteryRect.func_199318_a() <= mouseX && mouseX < this.getGuiLeft() + batteryRect.func_199318_a() + batteryRect.func_199316_c() && mouseY >= this.getGuiTop() + batteryRect.func_199319_b() && mouseY < this.getGuiTop() + batteryRect.func_199319_b() + batteryRect.func_199317_d()) {
                    ArrayList<String> toolTipText = new ArrayList<String>();
                    toolTipText.add(tooltip);
                    this.renderTooltip(toolTipText, mouseX - this.getGuiLeft() + 10, mouseY - this.getGuiTop());
                }
            });
        }
    }
}

