/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkEvent;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.energy.WaterworksBattery;
import org.terpo.waterworks.network.TankPacket;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class PumpPacket
extends TankPacket {
    private TileEntityGroundwaterPump tileEntityPump = null;
    int energyAmount = 0;

    public PumpPacket() {
    }

    public PumpPacket(TileEntityGroundwaterPump tileEntity) {
        super(tileEntity);
        this.tileEntityPump = tileEntity;
        this.tileEntityPump.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> {
            this.energyAmount = ((WaterworksBattery)((Object)e)).getEnergyStored();
        });
    }

    public static PumpPacket decode(PacketBuffer buf) {
        PumpPacket pumpPacket = new PumpPacket();
        PumpPacket.readPosition(buf, pumpPacket);
        PumpPacket.readTankInformation(buf, pumpPacket);
        pumpPacket.energyAmount = buf.readInt();
        return pumpPacket;
    }

    public static void encode(PumpPacket tankPacket, PacketBuffer buf) {
        PumpPacket.writePosition(tankPacket, buf);
        PumpPacket.writeTankInformation(tankPacket, buf);
        buf.writeInt(tankPacket.energyAmount);
    }

    public static void consume(PumpPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.tileEntityPosition;
            PlayerEntity clientPlayerEntity = Waterworks.proxy.getClientPlayerEntity();
            if (clientPlayerEntity.field_70170_p.isAreaLoaded(pos, 0)) {
                TileEntity tileEntity = PumpPacket.getTileEntity(clientPlayerEntity.field_70170_p, pos);
                if (tileEntity instanceof TileWaterworks) {
                    PumpPacket.handleTankInformation(message, (TileWaterworks)tileEntity);
                }
                if (tileEntity instanceof TileEntityGroundwaterPump) {
                    tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> ((WaterworksBattery)((Object)((Object)e))).setEnergyAmount(message.energyAmount));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

