/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.setup;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.block.BlockGroundwaterPump;
import org.terpo.waterworks.block.BlockRainCollector;
import org.terpo.waterworks.block.BlockRainCollectorController;
import org.terpo.waterworks.block.BlockRainTankWood;
import org.terpo.waterworks.block.BlockWaterPipe;
import org.terpo.waterworks.entity.item.EntityFireworkRocketAntiRain;
import org.terpo.waterworks.entity.item.EntityFireworkRocketRain;
import org.terpo.waterworks.gui.ContainerBase;
import org.terpo.waterworks.gui.pump.PumpContainer;
import org.terpo.waterworks.item.ItemFireworkAntiRain;
import org.terpo.waterworks.item.ItemFireworkRain;
import org.terpo.waterworks.item.ItemMaterialController;
import org.terpo.waterworks.item.ItemMaterialEnergyAdapter;
import org.terpo.waterworks.item.ItemPipeWrench;
import org.terpo.waterworks.item.ItemWaterworksDebugger;
import org.terpo.waterworks.item.crafting.AntiRainRocketRecipe;
import org.terpo.waterworks.item.crafting.RainRocketRecipe;
import org.terpo.waterworks.setup.CommonSetup;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileEntityRainCollector;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;
import org.terpo.waterworks.tileentity.TileEntityRainTankWood;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "waterworks");
    private static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "waterworks");
    private static final DeferredRegister<TileEntityType<?>> TILES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "waterworks");
    private static final DeferredRegister<ContainerType<?>> CONTAINERS = new DeferredRegister(ForgeRegistries.CONTAINERS, "waterworks");
    private static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "waterworks");
    private static final DeferredRegister<IRecipeSerializer<?>> RECIPES = new DeferredRegister(ForgeRegistries.RECIPE_SERIALIZERS, "waterworks");
    public static final RegistryObject<BlockRainTankWood> rainTankWoodBlock = BLOCKS.register("rain_tank_wood", BlockRainTankWood::new);
    public static final RegistryObject<BlockWaterPipe> waterPipeBlock = BLOCKS.register("water_pipe", BlockWaterPipe::new);
    public static final RegistryObject<BlockRainCollector> rainCollectorBlock = BLOCKS.register("rain_collector", BlockRainCollector::new);
    public static final RegistryObject<BlockRainCollectorController> rainCollectorControllerBlock = BLOCKS.register("rain_collector_controller", BlockRainCollectorController::new);
    public static final RegistryObject<BlockGroundwaterPump> groundwaterPumpBlock = BLOCKS.register("groundwater_pump", BlockGroundwaterPump::new);
    public static final RegistryObject<Item> rainTankWoodBlockItem = ITEMS.register("rain_tank_wood", () -> new BlockItem((Block)rainTankWoodBlock.get(), new Item.Properties().func_200916_a(CommonSetup.CREATIVE_TAB)));
    public static final RegistryObject<Item> waterPipeBlockItem = ITEMS.register("water_pipe", () -> new BlockItem((Block)waterPipeBlock.get(), new Item.Properties().func_200916_a(CommonSetup.CREATIVE_TAB)));
    public static final RegistryObject<Item> rainCollectorBlockItem = ITEMS.register("rain_collector", () -> new BlockItem((Block)rainCollectorBlock.get(), new Item.Properties().func_200916_a(CommonSetup.CREATIVE_TAB)));
    public static final RegistryObject<Item> rainCollectorControllerBlockItem = ITEMS.register("rain_collector_controller", () -> new BlockItem((Block)rainCollectorControllerBlock.get(), new Item.Properties().func_200916_a(CommonSetup.CREATIVE_TAB)));
    public static final RegistryObject<Item> groundwaterPumpBlockItem = ITEMS.register("groundwater_pump", () -> new BlockItem((Block)groundwaterPumpBlock.get(), new Item.Properties().func_200916_a(CommonSetup.CREATIVE_TAB)));
    public static final RegistryObject<TileEntityType<TileEntityRainTankWood>> rainTankWoodTile = TILES.register("rain_tank_wood", () -> TileEntityType.Builder.func_223042_a(TileEntityRainTankWood::new, (Block[])new Block[]{(Block)rainTankWoodBlock.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<TileEntityRainCollector>> rainCollectorTile = TILES.register("rain_collector", () -> TileEntityType.Builder.func_223042_a(TileEntityRainCollector::new, (Block[])new Block[]{(Block)rainCollectorBlock.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<TileEntityRainCollectorController>> rainCollectorControllerTile = TILES.register("rain_collector_controller", () -> TileEntityType.Builder.func_223042_a(TileEntityRainCollectorController::new, (Block[])new Block[]{(Block)rainCollectorControllerBlock.get()}).func_206865_a(null));
    public static final RegistryObject<TileEntityType<TileEntityGroundwaterPump>> groundwaterPumpTile = TILES.register("groundwater_pump", () -> TileEntityType.Builder.func_223042_a(TileEntityGroundwaterPump::new, (Block[])new Block[]{(Block)groundwaterPumpBlock.get()}).func_206865_a(null));
    public static final RegistryObject<ItemWaterworksDebugger> waterworksDebuggerItem = ITEMS.register("waterworks_debugger", ItemWaterworksDebugger::new);
    public static final RegistryObject<ItemPipeWrench> pipeWrenchItem = ITEMS.register("pipe_wrench", ItemPipeWrench::new);
    public static final RegistryObject<ItemFireworkRain> fireworkRainItem = ITEMS.register("firework_rain", ItemFireworkRain::new);
    public static final RegistryObject<ItemFireworkAntiRain> fireworkAntiRainItem = ITEMS.register("firework_anti_rain", ItemFireworkAntiRain::new);
    public static final RegistryObject<ItemMaterialEnergyAdapter> materialEnergyAdapterItem = ITEMS.register("material_energy_adapter", ItemMaterialEnergyAdapter::new);
    public static final RegistryObject<ItemMaterialController> materialControllerItem = ITEMS.register("material_controller", ItemMaterialController::new);
    public static final RegistryObject<EntityType<EntityFireworkRocketRain>> fireworkRainEntity = ENTITIES.register("firework_rain", () -> EntityType.Builder.func_220322_a(EntityFireworkRocketRain::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_206830_a("firework_rain"));
    public static final RegistryObject<EntityType<EntityFireworkRocketAntiRain>> fireworkAntiRainEntity = ENTITIES.register("firework_anti_rain", () -> EntityType.Builder.func_220322_a(EntityFireworkRocketAntiRain::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_206830_a("firework_rain"));
    public static final RegistryObject<ContainerType<ContainerBase>> rainTankWoodContainer = CONTAINERS.register("rain_tank_wood", () -> IForgeContainerType.create((windowId, inventory, data) -> new ContainerBase((ContainerType)rainTankWoodContainer.get(), windowId, (IInventory)inventory, Waterworks.proxy.getClientWorld().func_175625_s(data.func_179259_c()))));
    public static final RegistryObject<ContainerType<ContainerBase>> rainCollectorControllerContainer = CONTAINERS.register("rain_collector_controller", () -> IForgeContainerType.create((windowId, inventory, data) -> new ContainerBase((ContainerType)rainCollectorControllerContainer.get(), windowId, (IInventory)inventory, Waterworks.proxy.getClientWorld().func_175625_s(data.func_179259_c()))));
    public static final RegistryObject<ContainerType<PumpContainer>> groundwaterPumpContainer = CONTAINERS.register("groundwater_pump", () -> IForgeContainerType.create((windowId, inventory, data) -> new PumpContainer(windowId, (IInventory)inventory, Waterworks.proxy.getClientWorld().func_175625_s(data.func_179259_c()))));
    public static final RegistryObject<IRecipeSerializer<RainRocketRecipe>> fireworkRainRecipe = RECIPES.register("firework_rain", () -> new SpecialRecipeSerializer(RainRocketRecipe::new));
    public static final RegistryObject<IRecipeSerializer<AntiRainRocketRecipe>> fireworkAntiRainRecipe = RECIPES.register("firework_anti_rain", () -> new SpecialRecipeSerializer(AntiRainRocketRecipe::new));

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        TILES.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        RECIPES.register(modEventBus);
    }

    private Registration() {
    }

    public static Set<Block> getAllWaterworksBlocks() {
        return Sets.newHashSet((Object[])new Block[]{(Block)rainTankWoodBlock.get(), (Block)waterPipeBlock.get(), (Block)rainCollectorBlock.get(), (Block)rainCollectorControllerBlock.get(), (Block)groundwaterPumpBlock.get()});
    }
}

