/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.terpo.waterworks.Config;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.gui.ContainerBase;
import org.terpo.waterworks.helper.AreaHelper;
import org.terpo.waterworks.setup.Registration;
import org.terpo.waterworks.tileentity.TileEntityRainCollector;
import org.terpo.waterworks.tileentity.TileEntityRainTankWood;

public class TileEntityRainCollectorController
extends TileEntityRainTankWood {
    private static final String NBT_VALID_COLLECTORS = "validCollectors";
    private static final String NBT_COLLECTOR_POS_LIST = "collectorPosList";
    private static final String NBT_COLLECTOR_POS = "collectorPos";
    private static final String NBT_CONNECTED_BLOCKS = "connectedBlocks";
    private final int controllerRange = Config.rainCollection.getRainCollectorRange();
    private final int areaCount = (int)Math.pow((double)this.controllerRange * 2.0 + 1.0, 2.0);
    private BlockPos[] rainCollectorBlocks = new BlockPos[this.areaCount];
    protected int connectedCollectors = 1;
    private boolean isReset = false;
    protected int validCollectors = 0;
    private int currentValidationPos = 0;
    private int countValidCollectors = 0;

    public TileEntityRainCollectorController() {
        super((TileEntityType)Registration.rainCollectorControllerTile.get(), 0, Config.rainCollection.getRainCollectorCapacity());
    }

    @Override
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity entity) {
        return new ContainerBase((ContainerType)Registration.rainCollectorControllerContainer.get(), windowId, (IInventory)inventory, this);
    }

    @Override
    protected void updateServerSide() {
        if (this.isReset && this.needsUpdate(10)) {
            this.isDirty = true;
            this.findRainCollectors();
            this.isReset = false;
        }
        if (this.needsUpdate(15) && this.field_145850_b.func_72896_J()) {
            this.checkSelf();
            this.countValidCollectors();
        }
        super.updateServerSide();
    }

    private void checkSelf() {
        if (this.rainCollectorBlocks[0] == null) {
            this.rainCollectorBlocks[0] = new BlockPos((Vec3i)this.field_174879_c);
        }
    }

    @Override
    protected boolean isRefilling() {
        if (this.field_145850_b.func_72896_J()) {
            this.getFluidTank().fillInternal(this.fluidResource, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    private void countValidCollectors() {
        int maxValid = this.currentValidationPos + 5 > this.areaCount ? this.areaCount : this.currentValidationPos + 5;
        for (int i = this.currentValidationPos; i < maxValid; ++i) {
            if (this.rainCollectorBlocks[i] == null || !this.field_145850_b.func_175727_C(this.rainCollectorBlocks[i].func_177984_a())) continue;
            ++this.countValidCollectors;
        }
        this.currentValidationPos = maxValid;
        if (this.currentValidationPos == this.areaCount) {
            this.validCollectors = this.countValidCollectors;
            this.fluidResource = TileEntityRainCollectorController.getWaterFluidStack(this.validCollectors * Config.rainCollection.getRainCollectorFillrate());
            this.countValidCollectors = 0;
            this.currentValidationPos = 0;
        }
    }

    public int findRainCollectors() {
        this.resetController();
        this.connectedCollectors = this.getAllConnectedBlocks();
        this.fluidResource = TileEntityRainCollectorController.getWaterFluidStack(this.connectedCollectors * Config.rainCollection.getRainCollectorFillrate());
        return this.connectedCollectors;
    }

    public void debugCollectors() {
        Waterworks.LOGGER.info("Fill Multiplier @" + this.connectedCollectors);
        for (BlockPos blockPos : this.rainCollectorBlocks) {
            if (blockPos == null) continue;
            Waterworks.LOGGER.info("Collector @" + blockPos.toString());
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        int connectedBlocks = 0;
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.areaCount; ++i) {
            if (this.rainCollectorBlocks[i] == null) continue;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a(NBT_COLLECTOR_POS, this.rainCollectorBlocks[i].func_218275_a());
            list.add((Object)nbt);
            ++connectedBlocks;
        }
        compound.func_74768_a(NBT_CONNECTED_BLOCKS, connectedBlocks);
        compound.func_218657_a(NBT_COLLECTOR_POS_LIST, (INBT)list);
        compound.func_74768_a(NBT_VALID_COLLECTORS, this.validCollectors);
        return compound;
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_CONNECTED_BLOCKS)) {
            this.connectedCollectors = compound.func_74762_e(NBT_CONNECTED_BLOCKS);
            if (compound.func_74764_b(NBT_COLLECTOR_POS_LIST)) {
                ListNBT list = compound.func_150295_c(NBT_COLLECTOR_POS_LIST, 10);
                if (list.size() > this.areaCount) {
                    this.rainCollectorBlocks = new BlockPos[list.size()];
                    this.isReset = true;
                }
                for (int i = 0; i < list.size(); ++i) {
                    CompoundNBT nbt = list.func_150305_b(i);
                    long nbtPos = nbt.func_74763_f(NBT_COLLECTOR_POS);
                    this.rainCollectorBlocks[i] = BlockPos.func_218283_e((long)nbtPos);
                }
            }
            if (compound.func_74764_b(NBT_VALID_COLLECTORS)) {
                this.validCollectors = compound.func_74762_e(NBT_VALID_COLLECTORS);
                this.fluidResource = TileEntityRainCollectorController.getWaterFluidStack(this.validCollectors * Config.rainCollection.getRainCollectorFillrate());
            }
        }
    }

    private boolean isValidBlock(BlockPos blockPos, int currentIndex) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
        if (!(tileEntity instanceof TileEntityRainCollector) || !AreaHelper.isInRange2D(blockPos, this.field_174879_c, this.controllerRange) || ((TileEntityRainCollector)tileEntity).hasController()) {
            return false;
        }
        for (int i = 0; i < currentIndex; ++i) {
            if (!this.rainCollectorBlocks[i].equals((Object)blockPos)) continue;
            return false;
        }
        return true;
    }

    private int getAllConnectedBlocks() {
        int foundBlockCount = 1;
        this.rainCollectorBlocks[0] = new BlockPos((Vec3i)this.field_174879_c);
        BlockPos.Mutable tempPos = new BlockPos.Mutable(this.rainCollectorBlocks[0]);
        for (int i = 0; i < foundBlockCount; ++i) {
            tempPos.func_189533_g((Vec3i)this.rainCollectorBlocks[i]);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                tempPos.func_189534_c(direction, 1);
                foundBlockCount = this.validateAndAddCollector(foundBlockCount, tempPos);
                tempPos.func_189534_c(direction.func_176734_d(), 1);
            }
        }
        return foundBlockCount;
    }

    protected int validateAndAddCollector(int foundBlockCount, BlockPos.Mutable tempPos) {
        int resultFoundBlockCount = foundBlockCount;
        if (this.isValidBlock((BlockPos)tempPos, resultFoundBlockCount)) {
            this.rainCollectorBlocks[resultFoundBlockCount++] = tempPos.func_185334_h();
            ((TileEntityRainCollector)this.field_145850_b.func_175625_s((BlockPos)tempPos)).setController(this);
        }
        return resultFoundBlockCount;
    }

    public void removeCollector(BlockPos collectorPos) {
        for (BlockPos blockPos : this.rainCollectorBlocks) {
            if (blockPos == null || !blockPos.equals((Object)collectorPos)) continue;
            this.isReset = true;
            return;
        }
    }

    public void resetController() {
        for (int i = 1; i < this.rainCollectorBlocks.length; ++i) {
            TileEntity tile;
            BlockPos blockPos = this.rainCollectorBlocks[i];
            if (blockPos == null || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileEntityRainCollector)) continue;
            ((TileEntityRainCollector)tile).breakConnection(this);
        }
        this.rainCollectorBlocks = new BlockPos[this.areaCount];
    }

    public int getConnectedCollectors() {
        return this.connectedCollectors;
    }

    public boolean isCollectorListed(BlockPos collectorPos) {
        if (this.rainCollectorBlocks != null) {
            for (int i = 0; i < this.rainCollectorBlocks.length; ++i) {
                if (this.rainCollectorBlocks[i] == null || !this.rainCollectorBlocks[i].equals((Object)collectorPos)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.waterworks.rain_collector", new Object[0]);
    }
}

