/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.Config;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.block.BlockWaterPipe;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.helper.WaterworksInventoryHelper;
import org.terpo.waterworks.item.ItemPipeWrench;
import org.terpo.waterworks.setup.Registration;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class BlockGroundwaterPump
extends BaseBlockTE<TileEntityGroundwaterPump> {
    private static final VoxelShape zAxisShape = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.8125, 0.875));
    private static final VoxelShape xAxisShape = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.8125, 1.0));

    public BlockGroundwaterPump() {
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult facing) {
        TileEntityGroundwaterPump tileEntity;
        if (!worldIn.field_72995_K && hand == Hand.MAIN_HAND && (tileEntity = this.getTileEntity(worldIn, pos)) instanceof TileEntityGroundwaterPump) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof ItemPipeWrench) {
                BlockGroundwaterPump.turnPumpModel(worldIn, pos, state);
                return ActionResultType.SUCCESS;
            }
            if (!heldItem.func_190926_b() && !playerIn.func_225608_bj_() && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).isPresent() && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, tileEntity, heldItem)) {
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)tileEntity, (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityGroundwaterPump();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState bs) {
        return true;
    }

    public int func_180641_l(BlockState bs, World world, BlockPos pos) {
        TileEntityGroundwaterPump te = this.getTileEntity(world, pos);
        if (te instanceof TileEntityGroundwaterPump) {
            return this.getTileEntity(world, pos).getComparatorOutput();
        }
        return 0;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntityGroundwaterPump tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof TileWaterworks) {
            LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.ifPresent(handler -> WaterworksInventoryHelper.dropItemsFromInventory(world, pos, handler));
        }
        BlockGroundwaterPump.breakPipes(world, pos);
        super.func_176208_a(world, pos, state, player);
    }

    private static void breakPipes(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        int count = 0;
        BlockPos.Mutable position = new BlockPos.Mutable();
        for (int y = pos.func_177956_o() - 1; y >= 0; --y) {
            position.func_181079_c(x, y, z);
            BlockState state = world.func_180495_p((BlockPos)position);
            if (!(state.func_177230_c() instanceof BlockWaterPipe)) break;
            world.func_175655_b((BlockPos)position, false);
            ++count;
        }
        if (count > 0) {
            BlockGroundwaterPump.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Registration.waterPipeBlock.get(), count));
            if (Config.pump.getGroundwaterPumpSafety()) {
                world.func_175656_a(pos.func_177977_b(), Blocks.field_196646_bz.func_176223_P());
            }
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return direction.func_176740_k() == Direction.Axis.X ? xAxisShape : zAxisShape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return direction.func_176740_k() == Direction.Axis.X ? xAxisShape : zAxisShape;
    }

    private static void turnPumpModel(World worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176746_e()), 2);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    @Override
    protected TileEntityGroundwaterPump getTileEntity(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        if (tE instanceof TileEntityGroundwaterPump) {
            return (TileEntityGroundwaterPump)tE;
        }
        return null;
    }
}

