/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.terpo.waterworks.block.BlockGroundwaterPump;
import org.terpo.waterworks.tileentity.TileEntityGroundwaterPump;

public class BlockWaterPipe
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape boundingBox = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625));
    private static final VoxelShape collisionBox = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.7375, 1.0, 0.7375));

    public BlockWaterPipe() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return collisionBox;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return boundingBox;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        BlockPos.Mutable newPos = pos.func_239590_i_();
        boolean stillSearching = true;
        while (stillSearching) {
            Block block = worldIn.func_180495_p((BlockPos)newPos.func_196234_d(0, 1, 0)).func_177230_c();
            if (block instanceof BlockGroundwaterPump) {
                TileEntity tE;
                if (block.hasTileEntity(state) && (tE = worldIn.func_175625_s((BlockPos)newPos)) instanceof TileEntityGroundwaterPump) {
                    ((TileEntityGroundwaterPump)tE).setStructureComplete(false);
                }
                stillSearching = false;
            }
            if (block instanceof BlockWaterPipe) continue;
            stillSearching = false;
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getBlockStateForPlacement(context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getBlockStateForPlacement(World world, BlockPos pos) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

