/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.energy;

import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.energy.EnergyStorage;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class WaterworksBattery
extends EnergyStorage {
    private static final String NBT_ENERGY_STORED = "energyStored";
    private final TileWaterworks tile;
    int lastTick = 0;
    private boolean dirty;

    public WaterworksBattery(int capacity, int maxReceive, int maxExtract, TileWaterworks tE) {
        super(capacity, maxReceive, maxExtract);
        this.tile = tE;
        this.lastTick = this.tile.getCurrentTick();
    }

    public int extractInternal(int energyAmount, boolean simulate) {
        if (!simulate && energyAmount <= this.energy) {
            this.energy -= energyAmount;
            this.dirty = true;
            return energyAmount;
        }
        return 0;
    }

    public boolean hasEnoughEnergy(int energyAmount) {
        return this.getEnergyStored() >= energyAmount;
    }

    public int receiveEnergy(int maximumReceive, boolean simulate) {
        int quantity = super.receiveEnergy(maximumReceive, simulate);
        if (quantity > 0) {
            this.dirty = true;
        }
        return quantity;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setEnergyAmount(int energyAmount) {
        this.energy = energyAmount > this.capacity ? this.capacity : energyAmount;
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a(NBT_ENERGY_STORED, this.energy);
        return compound;
    }

    public WaterworksBattery read(CompoundNBT compound) {
        if (compound.func_74764_b(NBT_ENERGY_STORED)) {
            this.energy = compound.func_74762_e(NBT_ENERGY_STORED);
        }
        return this;
    }
}

