/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.entity.item;

import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import org.terpo.waterworks.Waterworks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public abstract class EntityWeatherFireworkRocket
extends ProjectileEntity
implements IRendersAsItem,
IEntityAdditionalSpawnData {
    public static final String NBT_FIREWORKS = "Fireworks";
    public static final String NBT_SHOT_AT_ANGLE = "ShotAtAngle";
    protected int fireworkAge;
    protected int lifetime;
    protected LivingEntity boostedEntity;
    protected int duration;
    protected int durationMultiplier;

    public EntityWeatherFireworkRocket(EntityType<? extends EntityWeatherFireworkRocket> entity, World world) {
        super(entity, world);
    }

    public EntityWeatherFireworkRocket(EntityType<? extends EntityWeatherFireworkRocket> entityType, World worldIn, double x, double y, double z, ItemStack givenItem) {
        super(entityType, worldIn);
        this.func_70107_b(x, y, z);
        this.duration = this.getConfiguredDuration();
        this.durationMultiplier = -1;
        this.fireworkAge = 0;
        int i = 1;
        if (!givenItem.func_190926_b() && givenItem.func_77942_o()) {
            this.setRocketItem(givenItem);
            i += givenItem.func_190925_c(NBT_FIREWORKS).func_74771_c("Flight");
        }
        this.func_213293_j(this.field_70146_Z.nextGaussian() * 0.001, 0.05, this.field_70146_Z.nextGaussian() * 0.001);
        this.lifetime = 10 * i + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
        if (givenItem.func_77942_o()) {
            CompoundNBT tag = givenItem.func_77978_p();
            if (tag.func_74764_b(this.getRocketTypeTag())) {
                this.durationMultiplier = tag.func_74762_e(this.getRocketTypeTag());
            }
            if (this.durationMultiplier != -1) {
                this.duration = this.calculateDurationFromMultiplier(this.durationMultiplier);
            }
        }
    }

    public EntityWeatherFireworkRocket(EntityType<? extends EntityWeatherFireworkRocket> entityType, World world, ItemStack itemStack, LivingEntity entity) {
        this(entityType, world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), itemStack);
        this.setBoostedEntity(entity);
        this.boostedEntity = entity;
    }

    public EntityWeatherFireworkRocket(EntityType<? extends EntityWeatherFireworkRocket> entityType, World world, ItemStack itemStack, double x, double y, double z, boolean shotAtAngle) {
        this(entityType, world, x, y, z, itemStack);
        this.setShotAtAngle(shotAtAngle);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemstack = this.getRocketItem();
            CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a(NBT_FIREWORKS);
            Vector3d vec3d = this.func_213322_ci();
            this.field_70170_p.func_92088_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, compoundnbt);
        }
        super.func_70103_a(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void announceRocket(int time) {
        int days = time / 24000;
        int hours = time % 24000 / 1000;
        int min = time % 24000 % 1000 / 17;
        Waterworks.proxy.getClientPlayerEntity().func_145747_a(this.getAnnouncementText(time, days, hours, min), Util.field_240973_b_);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAttachedToEntity()) {
            if (this.boostedEntity == null) {
                this.getBoostedEntity().ifPresent(entityId -> {
                    Entity entity = this.field_70170_p.func_73045_a(entityId);
                    if (entity instanceof LivingEntity) {
                        this.boostedEntity = (LivingEntity)entity;
                    }
                });
            }
            if (this.boostedEntity != null) {
                if (this.boostedEntity.func_184613_cA()) {
                    Vector3d vector3d = this.boostedEntity.func_70040_Z();
                    Vector3d vector3d1 = this.boostedEntity.func_213322_ci();
                    this.boostedEntity.func_213317_d(vector3d1.func_72441_c(vector3d.field_72450_a * 0.1 + (vector3d.field_72450_a * 1.5 - vector3d1.field_72450_a) * 0.5, vector3d.field_72448_b * 0.1 + (vector3d.field_72448_b * 1.5 - vector3d1.field_72448_b) * 0.5, vector3d.field_72449_c * 0.1 + (vector3d.field_72449_c * 1.5 - vector3d1.field_72449_c) * 0.5));
                }
                this.func_70107_b(this.boostedEntity.func_226277_ct_(), this.boostedEntity.func_226278_cu_(), this.boostedEntity.func_226281_cx_());
                this.func_213317_d(this.boostedEntity.func_213322_ci());
            }
        } else {
            if (!this.isShotAtAngle()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.15, 1.0, 1.15).func_72441_c(0.0, 0.04, 0.0));
            }
            Vector3d vector3d2 = this.func_213322_ci();
            this.func_213315_a(MoverType.SELF, vector3d2);
            this.func_213317_d(vector3d2);
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((EntityWeatherFireworkRocket)this).func_230298_a_(arg_0), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER);
        if (!this.field_70145_X) {
            this.func_70227_a(raytraceresult);
            this.field_70160_al = true;
        }
        this.func_234617_x_();
        if (this.fireworkAge == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        if (this.field_70170_p.field_72995_K && this.fireworkAge == 0) {
            this.announceRocket(this.duration);
        }
        ++this.fireworkAge;
        if (this.field_70170_p.field_72995_K && this.fireworkAge % 2 < 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, this.func_226277_ct_(), this.func_226278_cu_() - 0.3, this.func_226281_cx_(), this.field_70146_Z.nextGaussian() * 0.05, -this.func_213322_ci().field_72448_b * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.fireworkAge > this.lifetime) {
            this.setDead();
        }
    }

    private void setDead() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)17);
        this.dealExplosionDamage();
        this.func_70106_y();
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)) {
            super.func_70227_a(result);
        }
    }

    private void dealExplosionDamage() {
        ListNBT listnbt;
        float f = 0.0f;
        ItemStack itemstack = this.getRocketItem();
        CompoundNBT compoundnbt = itemstack.func_190926_b() ? null : itemstack.func_179543_a(NBT_FIREWORKS);
        ListNBT listNBT = listnbt = compoundnbt != null ? compoundnbt.func_150295_c("Explosions", 10) : null;
        if (listnbt != null && !listnbt.isEmpty()) {
            f = 5.0f + (float)(listnbt.size() * 2);
        }
        if (f > 0.0f) {
            if (this.boostedEntity != null) {
                this.boostedEntity.func_70097_a(EntityWeatherFireworkRocket.firework(this, this.func_234616_v_()), 5.0f + (float)(listnbt.size() * 2));
            }
            Vector3d vector3d = this.func_213303_ch();
            for (LivingEntity livingentity : this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(5.0))) {
                if (livingentity == this.boostedEntity || !(this.func_70068_e((Entity)livingentity) <= 25.0)) continue;
                boolean flag = false;
                for (int i = 0; i < 2; ++i) {
                    Vector3d vector3d1 = new Vector3d(livingentity.func_226277_ct_(), livingentity.func_226283_e_(0.5 * (double)i), livingentity.func_226281_cx_());
                    BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                    if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d((Entity)livingentity)) / 5.0);
                livingentity.func_70097_a(EntityWeatherFireworkRocket.firework(this, this.func_234616_v_()), f1);
            }
        }
    }

    private static DamageSource firework(EntityWeatherFireworkRocket enitity, @Nullable Entity owner) {
        return new IndirectEntityDamageSource("fireworks", (Entity)enitity, owner).func_94540_d();
    }

    public boolean func_70075_an() {
        return false;
    }

    private boolean isAttachedToEntity() {
        return this.getBoostedEntity().isPresent();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70186_c(double incomingX, double incomingY, double incomingZ, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(incomingX * incomingX + incomingY * incomingY + incomingZ * incomingZ));
        double x = incomingX / (double)f;
        double y = incomingY / (double)f;
        double z = incomingZ / (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.duration);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.duration = additionalData.readInt();
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Life", this.fireworkAge);
        compound.func_74768_a("LifeTime", this.lifetime);
        ItemStack itemstack = this.getRocketItem();
        if (!itemstack.func_190926_b()) {
            compound.func_218657_a("FireworksItem", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a(NBT_SHOT_AT_ANGLE, this.isShotAtAngle());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.fireworkAge = compound.func_74762_e("Life");
        this.lifetime = compound.func_74762_e("LifeTime");
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("FireworksItem"));
        if (!itemstack.func_190926_b()) {
            this.setRocketItem(itemstack);
        }
        if (compound.func_74764_b(NBT_SHOT_AT_ANGLE)) {
            this.setShotAtAngle(compound.func_74767_n(NBT_SHOT_AT_ANGLE));
        }
    }

    public boolean equals(Object entity) {
        return super.equals(entity);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract ITextComponent getAnnouncementText(int var1, int var2, int var3, int var4);

    protected abstract void func_70088_a();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ItemStack getItemFromEntity();

    protected abstract boolean isShotAtAngle();

    protected abstract void setShotAtAngle(Boolean var1);

    protected abstract ItemStack getRocketItem();

    protected abstract void setRocketItem(ItemStack var1);

    protected abstract OptionalInt getBoostedEntity();

    protected abstract void setBoostedEntity(LivingEntity var1);

    protected abstract int calculateDurationFromMultiplier(int var1);

    protected abstract String getRocketTypeTag();

    protected abstract int getConfiguredDuration();
}

