/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.fluid;

import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class WaterworksTank
extends FluidTank {
    private final TileWaterworks tile;
    private boolean allowFilling;

    public WaterworksTank(int capacity, TileWaterworks tileWaterworks) {
        super(capacity);
        this.tile = tileWaterworks;
        this.allowFilling = false;
    }

    public boolean isEmpty() {
        return this.getFluidAmount() == 0;
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.getCapacity();
    }

    protected void onContentsChanged() {
        this.tile.setDirty(true);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.allowFilling) {
            return super.fill(resource, action);
        }
        return 0;
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    public WaterworksTank allowFilling(boolean newAllowFilling) {
        this.setAllowFilling(newAllowFilling);
        return this;
    }

    public boolean isAllowFilling() {
        return this.allowFilling;
    }

    public void setAllowFilling(boolean allowFilling) {
        this.allowFilling = allowFilling;
    }
}

