/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.helper;

import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.terpo.waterworks.inventory.SlotDefinition;
import org.terpo.waterworks.tileentity.BaseTileEntity;

public class GeneralItemStackHandler
extends ItemStackHandler {
    private boolean[] inputSlots;
    private boolean[] outputSlots;
    HashMap<Item, SlotDefinition> filter = new HashMap();
    protected TileEntity tile;

    public GeneralItemStackHandler() {
        super(1);
    }

    public GeneralItemStackHandler(int size, TileEntity tE) {
        super(size);
        this.inputSlots = new boolean[size];
        this.outputSlots = new boolean[size];
        this.filter.put(Items.field_151069_bo, SlotDefinition.I);
        this.filter.put(Items.field_151068_bn, SlotDefinition.O);
        for (int i = 0; i < size; ++i) {
            this.inputSlots[i] = false;
            this.outputSlots[i] = false;
        }
        this.tile = tE;
    }

    public void setTileEntity(TileEntity tile) {
        this.tile = tile;
    }

    protected void onContentsChanged(int slot) {
        if (this.tile instanceof BaseTileEntity) {
            ((BaseTileEntity)this.tile).setDirty(true);
        }
    }

    public void setInputFlagForIndex(int slot, boolean allowed) {
        this.validateSlotIndex(slot);
        this.inputSlots[slot] = allowed;
    }

    public void setOutputFlagForIndex(int slot, boolean allowed) {
        this.validateSlotIndex(slot);
        this.outputSlots[slot] = allowed;
    }

    public void setIOFlagForIndex(int slot, boolean allowed) {
        this.validateSlotIndex(slot);
        this.inputSlots[slot] = allowed;
        this.outputSlots[slot] = allowed;
    }

    public boolean isInputSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.inputSlots[slot];
    }

    public boolean isOutputSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.outputSlots[slot];
    }

    public GeneralItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isValidItemStack(stack, slot) || !this.isInputSlot(slot)) {
            return stack;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    protected boolean isValidItemStack(ItemStack stack, int slot) {
        if (slot <= 1) {
            return stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).isPresent() || this.additionalFilters(stack, slot);
        }
        return false;
    }

    protected boolean additionalFilters(ItemStack stack, int slot) {
        Item item = stack.func_77973_b();
        if (!this.filter.isEmpty() && this.filter.containsKey(item)) {
            SlotDefinition def = this.filter.get(item);
            return this.checkSlotDefinitionForSlot(def, slot);
        }
        return false;
    }

    private boolean checkSlotDefinitionForSlot(SlotDefinition def, int slot) {
        switch (def) {
            case I: {
                return this.isInputSlot(slot);
            }
            case O: {
                return this.isOutputSlot(slot);
            }
            case IO: {
                return this.isInputSlot(slot) && this.isOutputSlot(slot);
            }
        }
        return false;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        if (!this.isOutputSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public ItemStack extractItemByPlayer(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return null;
        }
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }
}

