/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;
import org.terpo.waterworks.Waterworks;
import org.terpo.waterworks.network.BasePacket;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TankPacket
extends BasePacket {
    private TileWaterworks tileEntity = null;
    int fluidAmount = 0;

    public TankPacket() {
    }

    public TankPacket(TileWaterworks tileEntity) {
        super(tileEntity);
        this.tileEntity = tileEntity;
        this.fluidAmount = this.tileEntity.getFluidTank().getFluidAmount();
    }

    public static TankPacket decode(PacketBuffer buf) {
        TankPacket tankPacket = new TankPacket();
        TankPacket.readPosition(buf, tankPacket);
        TankPacket.readTankInformation(buf, tankPacket);
        return tankPacket;
    }

    protected static void readTankInformation(PacketBuffer buf, TankPacket tankPacket) {
        tankPacket.fluidAmount = buf.readInt();
    }

    public static void encode(TankPacket tankPacket, PacketBuffer buf) {
        TankPacket.writePosition(tankPacket, buf);
        TankPacket.writeTankInformation(tankPacket, buf);
    }

    protected static void writeTankInformation(TankPacket tankPacket, PacketBuffer buf) {
        buf.writeInt(tankPacket.fluidAmount);
    }

    public static void consume(TankPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity tileEntity;
            BlockPos pos = message.tileEntityPosition;
            PlayerEntity clientPlayerEntity = Waterworks.proxy.getClientPlayerEntity();
            if (clientPlayerEntity.field_70170_p.isAreaLoaded(pos, 0) && (tileEntity = TankPacket.getTileEntity(clientPlayerEntity.field_70170_p, pos)) instanceof TileWaterworks) {
                TankPacket.handleTankInformation(message, (TileWaterworks)tileEntity);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    protected static void handleTankInformation(TankPacket message, TileWaterworks tileEntity) {
        tileEntity.getFluidTank().setFluid(new FluidStack((Fluid)Fluids.field_204546_a, message.fluidAmount > 0 ? message.fluidAmount : 0));
    }
}

