/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity.specialrenderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.tileentity.TileWaterworks;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityWaterRenderer
extends TileEntityRenderer<TileWaterworks> {
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    float minU;
    float minV;
    float maxU;
    float maxV;
    float diffU;
    float diffV;
    static final float START_POS = 0.0625f;
    static final float END_POS = 0.9375f;
    static final float Y_START_OFFSET = 0.125f;

    public TileEntityWaterRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileWaterworks te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        WaterworksTank tank = te.getFluidTank();
        int amount = tank.getFluidAmount();
        if (amount > 0) {
            int capacity = tank.getCapacity();
            FluidStack fluidStack = tank.getFluid();
            Fluid fluid = fluidStack.getFluid();
            if (fluid != null) {
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getAttributes().getStillTexture());
                IVertexBuilder builder = buffer.getBuffer(RenderType.func_228645_f_());
                int color = fluid.getAttributes().getColor();
                this.blue = color & 0xFF;
                this.green = color >> 8 & 0xFF;
                this.red = color >> 16 & 0xFF;
                this.alpha = color >> 24 & 0xFF;
                if (sprite != null) {
                    this.minU = sprite.func_94209_e();
                    this.maxU = sprite.func_94212_f();
                    this.minV = sprite.func_94206_g();
                    this.maxV = sprite.func_94210_h();
                    float yFilled = 0.8125f * ((float)amount / (float)capacity);
                    float yHeight = 0.125f + yFilled;
                    matrixStack.func_227860_a_();
                    this.add(builder, matrixStack, 0.0625f, yHeight, 0.9375f, this.minU, this.maxV);
                    this.add(builder, matrixStack, 0.9375f, yHeight, 0.9375f, this.maxU, this.maxV);
                    this.add(builder, matrixStack, 0.9375f, yHeight, 0.0625f, this.maxU, this.minV);
                    this.add(builder, matrixStack, 0.0625f, yHeight, 0.0625f, this.minU, this.minV);
                    matrixStack.func_227865_b_();
                }
            }
        }
    }

    private void add(IVertexBuilder vertexBuilder, MatrixStack matrixStack, float x, float y, float z, float u, float v) {
        vertexBuilder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_225586_a_(this.red, this.green, this.blue, this.alpha).func_225583_a_(u, v).func_225587_b_(0, 240).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

