/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.block;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import org.terpo.waterworks.block.BaseBlockTE;
import org.terpo.waterworks.helper.FluidHelper;
import org.terpo.waterworks.helper.WaterworksInventoryHelper;
import org.terpo.waterworks.item.ItemPipeWrench;
import org.terpo.waterworks.tileentity.TileEntityRainCollectorController;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class BlockRainCollectorController
extends BaseBlockTE<TileWaterworks> {
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.rain_collector_controller"));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRainCollectorController();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult facing) {
        TileWaterworks tileEntity;
        if (!worldIn.field_72995_K && hand == Hand.MAIN_HAND && (tileEntity = this.getTileEntity(worldIn, pos)) instanceof TileEntityRainCollectorController) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof ItemPipeWrench) {
                int collectors = ((TileEntityRainCollectorController)tileEntity).findRainCollectors();
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("block.waterworks.rain_collector_controller.controllers", new Object[]{collectors - 1}), Util.field_240973_b_);
                return ActionResultType.SUCCESS;
            }
            if (!heldItem.func_190926_b() && !playerIn.func_225608_bj_() && tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent() && FluidHelper.interactWithFluidHandler(worldIn, pos, playerIn, hand, facing, tileEntity, heldItem)) {
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)tileEntity, (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileWaterworks tileEntity = this.getTileEntity(world, pos);
        if (tileEntity != null) {
            LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            capability.ifPresent(handler -> WaterworksInventoryHelper.dropItemsFromInventory(world, pos, handler));
        }
        if (tileEntity instanceof TileEntityRainCollectorController) {
            ((TileEntityRainCollectorController)tileEntity).resetController();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149740_M(BlockState bs) {
        return true;
    }

    public int func_180641_l(BlockState bs, World world, BlockPos pos) {
        TileWaterworks te = this.getTileEntity(world, pos);
        if (te instanceof TileWaterworks) {
            return this.getTileEntity(world, pos).getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity te;
        if (player.func_225608_bj_() && (te = world.func_175625_s(data.getPos())) instanceof TileEntityRainCollectorController) {
            TileEntityRainCollectorController tile = (TileEntityRainCollectorController)te;
            probeInfo.horizontal().text((ITextComponent)new TranslationTextComponent("tooltip.collectors", new Object[]{tile.getConnectedCollectors()}));
        }
    }

    @Override
    protected TileWaterworks getTileEntity(World world, BlockPos pos) {
        TileEntity tE = world.func_175625_s(pos);
        if (tE instanceof TileWaterworks) {
            return (TileWaterworks)tE;
        }
        return null;
    }
}

