/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.entity.item;

import java.util.OptionalInt;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.terpo.waterworks.Config;
import org.terpo.waterworks.entity.item.EntityWeatherFireworkRocket;
import org.terpo.waterworks.setup.Registration;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EntityFireworkRocketAntiRain
extends EntityWeatherFireworkRocket {
    private static final DataParameter<ItemStack> ANTI_RAINROCKET_ITEM = EntityDataManager.func_187226_a(EntityFireworkRocketAntiRain.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<OptionalInt> BOOSTED_ANTI_RAINROCKET_ENTITY_ID = EntityDataManager.func_187226_a(EntityFireworkRocketAntiRain.class, (IDataSerializer)DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> SHOT_AT_ANGLE_ANTI_RAINROCKET_BOOLEAN = EntityDataManager.func_187226_a(EntityFireworkRocketAntiRain.class, (IDataSerializer)DataSerializers.field_187198_h);

    public EntityFireworkRocketAntiRain(EntityType<? extends EntityFireworkRocketAntiRain> entity, World world) {
        super(entity, world);
    }

    public EntityFireworkRocketAntiRain(World worldIn, double x, double y, double z, ItemStack itemstack) {
        super((EntityType<? extends EntityWeatherFireworkRocket>)((EntityType)Registration.fireworkAntiRainEntity.get()), worldIn, x, y, z, itemstack);
    }

    public EntityFireworkRocketAntiRain(World worldIn, ItemStack itemstack, LivingEntity entity) {
        super((EntityType<? extends EntityWeatherFireworkRocket>)((EntityType)Registration.fireworkAntiRainEntity.get()), worldIn, itemstack, entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getAnnouncementText(int time, int days, int hours, int min) {
        return new TranslationTextComponent("entity.anti_rain_rocket.announcement", new Object[]{time, days, hours, min});
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ANTI_RAINROCKET_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(BOOSTED_ANTI_RAINROCKET_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(SHOT_AT_ANGLE_ANTI_RAINROCKET_BOOLEAN, (Object)false);
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K) {
            ((ServerWorld)this.func_130014_f_()).func_241113_a_(this.duration, 0, false, false);
            this.dropSponge(this.func_233580_cy_());
        }
        super.func_70106_y();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        ItemStack itemstack = this.getRocketItem();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)Registration.fireworkAntiRainItem.get()) : itemstack;
    }

    @Override
    public boolean isShotAtAngle() {
        Boolean shotAtAngle = (Boolean)this.field_70180_af.func_187225_a(SHOT_AT_ANGLE_ANTI_RAINROCKET_BOOLEAN);
        return shotAtAngle != null && shotAtAngle != false;
    }

    @Override
    public void setShotAtAngle(Boolean shotAtAngle) {
        this.field_70180_af.func_187227_b(SHOT_AT_ANGLE_ANTI_RAINROCKET_BOOLEAN, (Object)shotAtAngle);
    }

    @Override
    public ItemStack getRocketItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ANTI_RAINROCKET_ITEM);
    }

    @Override
    public void setRocketItem(ItemStack givenItem) {
        this.field_70180_af.func_187227_b(ANTI_RAINROCKET_ITEM, (Object)givenItem.func_77946_l());
    }

    @Override
    public OptionalInt getBoostedEntity() {
        return (OptionalInt)this.field_70180_af.func_187225_a(BOOSTED_ANTI_RAINROCKET_ENTITY_ID);
    }

    @Override
    public void setBoostedEntity(LivingEntity entity) {
        this.field_70180_af.func_187227_b(BOOSTED_ANTI_RAINROCKET_ENTITY_ID, (Object)OptionalInt.of(entity.func_145782_y()));
    }

    @Override
    protected int calculateDurationFromMultiplier(int antiRainMultiplier) {
        int minimumClearSky = Config.rockets.getClearSkyDuration() * antiRainMultiplier;
        return minimumClearSky + this.calculateAdditionalTime(antiRainMultiplier);
    }

    @Override
    protected String getRocketTypeTag() {
        return "ANTIRAIN";
    }

    @Override
    protected int getConfiguredDuration() {
        return Config.rockets.getClearSkyDuration();
    }

    private int calculateAdditionalTime(int multiplier) {
        int maximumClearAdditionalDays = Config.rockets.getClearSkyMaxRandomAdditionalDays();
        if (maximumClearAdditionalDays == 0) {
            return 0;
        }
        int maxClearTicks = maximumClearAdditionalDays * 24000;
        float multi = (float)Config.rockets.getClearSkyMaxMultiplier() / (((float)multiplier + 0.001f) * 6.0f);
        float randomMultiplier = multi * (this.field_70146_Z.nextFloat() * 48.0f) + 1.0f;
        double log = Math.log(randomMultiplier) / 4.0;
        if (log > 1.0) {
            log = 1.0;
        }
        return (int)Math.round((double)maxClearTicks - (double)maxClearTicks * log);
    }

    private void dropSponge(BlockPos pos) {
        if (this.durationMultiplier >= 1) {
            for (int i = 0; i < this.durationMultiplier; ++i) {
                this.func_130014_f_().func_217376_c((Entity)new ItemEntity(this.func_130014_f_(), (double)pos.func_177958_n() + this.field_70146_Z.nextDouble() * 2.0 - 1.0, (double)pos.func_177956_o() + this.field_70146_Z.nextDouble() * 2.0 - 1.0, (double)pos.func_177952_p() + this.field_70146_Z.nextDouble() * 2.0 - 1.0, this.func_130014_f_().func_72896_J() ? new ItemStack((IItemProvider)Blocks.field_196577_ad, 1) : new ItemStack((IItemProvider)Blocks.field_150360_v, 1)));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItemFromEntity() {
        return this.func_184543_l();
    }
}

