/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.terpo.waterworks.fluid.WaterworksTank;
import org.terpo.waterworks.gui.ContainerBase;
import org.terpo.waterworks.tileentity.TileWaterworks;

@OnlyIn(value=Dist.CLIENT)
public class FluidContainerScreen
extends ContainerScreen<ContainerBase> {
    protected WaterworksTank fluidTank;
    protected TileWaterworks tileEntity;
    protected ResourceLocation gui;
    protected Rectangle2d tankRectangle;
    private ResourceLocation waterResource;
    private float[] colors;
    private boolean hasColorAttributes;

    public FluidContainerScreen(ContainerBase screenContainer, PlayerInventory inv, ITextComponent title) {
        super((Container)screenContainer, inv, title);
        this.prepare(new ResourceLocation("waterworks", "textures/gui/container/rain_tank_wood.png"), new Rectangle2d(80, 17, 16, 52), screenContainer);
    }

    protected void prepare(ResourceLocation newGui, Rectangle2d newTankRectangle, ContainerBase screenContainer) {
        this.tileEntity = screenContainer.getTileWaterworks();
        this.fluidTank = screenContainer.getTileWaterworks().getFluidTank();
        this.gui = newGui;
        this.tankRectangle = newTankRectangle;
        this.hasColorAttributes = this.defineColors();
    }

    protected boolean defineColors() {
        Fluid fluid = this.fluidTank.getFluid().getFluid();
        this.waterResource = fluid.getAttributes().getStillTexture();
        int color = fluid.getAttributes().getColor();
        this.colors = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return 0.0f != this.colors[0];
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.gui);
        this.func_238474_b_(matrixStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        this.drawTank(matrixStack, this.tankRectangle.func_199318_a(), this.tankRectangle.func_199316_c(), this.tankRectangle.func_199319_b(), this.tankRectangle.func_199317_d());
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.drawTankTooltip(matrixStack, mouseX, mouseY, this.tankRectangle.func_199318_a(), this.tankRectangle.func_199316_c(), this.tankRectangle.func_199319_b(), this.tankRectangle.func_199317_d());
    }

    protected void drawTank(MatrixStack matrixStack, int tankPosX, int tankSizeX, int tankPosY, int tankSizeY) {
        if (this.fluidTank != null) {
            if (!this.hasColorAttributes) {
                this.hasColorAttributes = this.defineColors();
            }
            int fillHeight = this.fluidTank.getFluidAmount() * tankSizeY / this.fluidTank.getCapacity();
            this.field_230706_i_.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            RenderSystem.color4f((float)this.colors[0], (float)this.colors[1], (float)this.colors[2], (float)this.colors[3]);
            AbstractGui.func_238470_a_((MatrixStack)matrixStack, (int)(this.getGuiLeft() + tankPosX), (int)(this.getGuiTop() + tankPosY + tankSizeY - fillHeight), (int)0, (int)tankSizeX, (int)fillHeight, (TextureAtlasSprite)((TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(this.waterResource)));
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawTankTooltip(MatrixStack matrixStack, int mouseX, int mouseY, int xStartTank, int xSizeTank, int yStartTank, int ySizeTank) {
        if (this.fluidTank != null) {
            StringTextComponent tooltip = new StringTextComponent(this.fluidTank.getFluidAmount() + "/" + this.fluidTank.getCapacity() + " mB");
            if (this.getGuiLeft() + xStartTank <= mouseX && mouseX < this.getGuiLeft() + xStartTank + xSizeTank && mouseY >= this.getGuiTop() + yStartTank && mouseY < this.getGuiTop() + yStartTank + ySizeTank) {
                this.func_238652_a_(matrixStack, (ITextComponent)tooltip, mouseX - this.getGuiLeft() + 10, mouseY - this.getGuiTop());
            }
        }
    }
}

