/*
 * Decompiled with CFR 0.152.
 */
package org.terpo.waterworks.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.terpo.waterworks.Config;
import org.terpo.waterworks.block.BlockWaterPipe;
import org.terpo.waterworks.energy.WaterworksBattery;
import org.terpo.waterworks.gui.pump.PumpContainer;
import org.terpo.waterworks.helper.GeneralItemStackHandler;
import org.terpo.waterworks.helper.PumpItemStackHandler;
import org.terpo.waterworks.network.PumpPacket;
import org.terpo.waterworks.network.WaterworksPacketHandler;
import org.terpo.waterworks.setup.Registration;
import org.terpo.waterworks.tileentity.TileWaterworks;

public class TileEntityGroundwaterPump
extends TileWaterworks {
    private static final String NBT_BOOLEAN_STRUCTURE_COMPLETE = "structureComplete";
    private static final String NBT_INT_PIPE_COUNTER = "pipeCounter";
    private static final String NBT_INT_ENERGY_USAGE = "energyUsage";
    private static final int PUMP_INVENTORY_SLOTS = 5;
    private static final int PIPE_INVENTARY_SLOT_START = 2;
    protected FluidStack resourceWater = null;
    private int pipeCounter = 1;
    private boolean structureComplete = false;
    private final LazyOptional<WaterworksBattery> battery = LazyOptional.of(this::createBattery);
    private int energyUsage = Config.pump.getGroundwaterPumpEnergyBaseUsage() + Config.pump.getGroundwaterPumpEnergyPipeMultiplier() * this.pipeCounter;

    public TileEntityGroundwaterPump() {
        this(Config.pump.getGroundwaterPumpFillrate(), Config.pump.getGroundwaterPumpCapacity());
    }

    public TileEntityGroundwaterPump(int fillrate, int capacity) {
        super((TileEntityType)Registration.groundwaterPumpTile.get(), 5, capacity);
        this.resourceWater = new FluidStack((Fluid)Fluids.field_204546_a, fillrate);
    }

    @Override
    protected GeneralItemStackHandler createItemHandler() {
        PumpItemStackHandler handler = new PumpItemStackHandler(this.inventorySize, this);
        handler.setInputFlagForIndex(0, true);
        handler.setOutputFlagForIndex(1, true);
        handler.setInputFlagForIndex(2, true);
        handler.setInputFlagForIndex(3, true);
        handler.setInputFlagForIndex(4, true);
        return handler;
    }

    protected WaterworksBattery createBattery() {
        return new WaterworksBattery(Config.pump.getGroundwaterPumpEnergyCapacity(), Config.pump.getGroundwaterPumpEnergyInput(), 0, this);
    }

    @Override
    protected void updateServerSide() {
        if (this.needsUpdate(5) && this.fillFluid()) {
            this.isDirty = true;
        }
        if (this.needsUpdate(20)) {
            this.battery.ifPresent(b -> {
                if (b.isDirty()) {
                    this.isDirty = true;
                    b.setDirty(false);
                }
            });
            if (!this.structureComplete) {
                this.checkStructure();
            } else {
                if (this.needsUpdate(100)) {
                    this.checkStructure();
                }
                if (this.refill()) {
                    this.isDirty = true;
                }
            }
        }
        super.updateServerSide();
    }

    private boolean refill() {
        WaterworksBattery waterworksBattery = (WaterworksBattery)((Object)this.battery.orElseGet(this::createBattery));
        if (waterworksBattery != null && waterworksBattery.getEnergyStored() >= this.energyUsage) {
            int filled = this.getFluidTank().fillInternal(this.resourceWater, IFluidHandler.FluidAction.EXECUTE);
            if (filled == Config.pump.getGroundwaterPumpFillrate()) {
                return waterworksBattery.extractInternal(this.energyUsage, false) > 0;
            }
            if (filled > 0) {
                int energy = this.energyUsage * Math.round((float)filled / (float)Config.pump.getGroundwaterPumpFillrate());
                return waterworksBattery.extractInternal(energy, false) > 0;
            }
        }
        return false;
    }

    private void checkStructure() {
        int count = 0;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o() - 1;
        int z = this.field_174879_c.func_177952_p();
        ArrayList<Block> bedrocks = new ArrayList<Block>();
        bedrocks.add(Blocks.field_150357_h);
        WaterworksBattery internalBattery = (WaterworksBattery)((Object)this.battery.orElseGet(this::createBattery));
        GeneralItemStackHandler handler = (GeneralItemStackHandler)((Object)this.itemStackHandler.orElseGet(this::createItemHandler));
        BlockPos.Mutable currentPos = new BlockPos.Mutable();
        boolean stillChecking = true;
        while (y >= 0 && stillChecking) {
            BlockState state = this.field_145850_b.func_180495_p((BlockPos)currentPos.func_181079_c(x, y, z));
            Block block = state.func_177230_c();
            if (block instanceof BlockWaterPipe) {
                ++count;
                --y;
                continue;
            }
            if (bedrocks.contains(block) || !Config.pump.getGroundwaterPumpCheckBedrock() && y < 0) {
                this.structureComplete = true;
                this.pipeCounter = count;
                this.energyUsage = Config.pump.getGroundwaterPumpEnergyBaseUsage() + Config.pump.getGroundwaterPumpEnergyPipeMultiplier() * this.pipeCounter;
                return;
            }
            if ((block instanceof AirBlock || block == Blocks.field_150355_j) && internalBattery.hasEnoughEnergy(Config.pump.getGroundwaterPumpEnergyPipePlacement()) && this.placePipe((BlockPos)currentPos, handler)) {
                internalBattery.extractInternal(Config.pump.getGroundwaterPumpEnergyPipePlacement(), false);
            }
            this.structureComplete = false;
            stillChecking = false;
        }
    }

    private boolean placePipe(BlockPos currentPos, ItemStackHandler handler) {
        HashMap<ItemStack, Integer> stacks = this.getPipeStacks(handler);
        if (!stacks.isEmpty()) {
            BlockWaterPipe pipe = (BlockWaterPipe)Registration.waterPipeBlock.get();
            stacks.forEach((stack, slot) -> {
                if (pipe != null && this.field_145850_b.func_180501_a(currentPos, pipe.getBlockStateForPlacement(this.field_145850_b, currentPos), 2)) {
                    if (stack.func_190916_E() > 1) {
                        stack.func_190918_g(1);
                    } else {
                        handler.setStackInSlot(slot.intValue(), ItemStack.field_190927_a);
                    }
                    return;
                }
            });
            return true;
        }
        return false;
    }

    private HashMap<ItemStack, Integer> getPipeStacks(ItemStackHandler handler) {
        HashMap<ItemStack, Integer> pipeStack = new HashMap<ItemStack, Integer>();
        for (int i = 2; i < this.inventorySize; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            pipeStack.put(stack, i);
        }
        return pipeStack;
    }

    public boolean isStructureComplete() {
        return this.structureComplete;
    }

    public void setStructureComplete(boolean structureComplete) {
        this.structureComplete = structureComplete;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.battery.cast();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    protected void sendUpdatePacket() {
        WaterworksPacketHandler.sendToAllAround(new PumpPacket(this), this);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.battery.ifPresent(b -> b.write(compound));
        compound.func_74768_a(NBT_INT_ENERGY_USAGE, this.energyUsage);
        compound.func_74768_a(NBT_INT_PIPE_COUNTER, this.pipeCounter);
        compound.func_74757_a(NBT_BOOLEAN_STRUCTURE_COMPLETE, this.structureComplete);
        return compound;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.battery.ifPresent(b -> b.read(compound));
        if (compound.func_74764_b(NBT_INT_ENERGY_USAGE)) {
            this.energyUsage = compound.func_74762_e(NBT_INT_ENERGY_USAGE);
        }
        if (compound.func_74764_b(NBT_INT_PIPE_COUNTER)) {
            this.pipeCounter = compound.func_74762_e(NBT_INT_PIPE_COUNTER);
        }
        if (compound.func_74764_b(NBT_BOOLEAN_STRUCTURE_COMPLETE)) {
            this.structureComplete = compound.func_74767_n(NBT_BOOLEAN_STRUCTURE_COMPLETE);
        }
    }

    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity entity) {
        return new PumpContainer(windowId, (IInventory)inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("block.waterworks.groundwater_pump");
    }
}

