/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GlobalWaystones
extends WorldSavedData {
    private static final String DATA_NAME = "waystones_GlobalWaystones";
    private static final String TAG_LIST_NAME = "GlobalWaystones";
    private final Map<String, WaystoneEntry> globalWaystones = Maps.newHashMap();

    public GlobalWaystones() {
        super(DATA_NAME);
    }

    public GlobalWaystones(String name) {
        super(name);
    }

    public void addGlobalWaystone(WaystoneEntry entry) {
        this.globalWaystones.put(entry.getName(), entry);
        this.func_76185_a();
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            WaystoneManager.addPlayerWaystone(player, entry);
        }
    }

    public void removeGlobalWaystone(WaystoneEntry entry) {
        this.globalWaystones.remove(entry.getName());
        this.func_76185_a();
        for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            WaystoneManager.removePlayerWaystone(player, entry);
        }
    }

    public Collection<WaystoneEntry> getGlobalWaystones() {
        return this.globalWaystones.values();
    }

    @Nullable
    public WaystoneEntry getGlobalWaystone(String name) {
        return this.globalWaystones.get(name);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_150295_c(TAG_LIST_NAME, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            WaystoneEntry entry = WaystoneEntry.read((NBTTagCompound)tagList.func_179238_g(i));
            this.globalWaystones.put(entry.getName(), entry);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (WaystoneEntry entry : this.globalWaystones.values()) {
            tagList.func_74742_a((NBTBase)entry.writeToNBT());
        }
        tagCompound.func_74782_a(TAG_LIST_NAME, (NBTBase)tagList);
        return tagCompound;
    }

    public static GlobalWaystones get(World world) {
        MapStorage storage = world.func_175693_T();
        if (storage != null) {
            GlobalWaystones instance = (GlobalWaystones)storage.func_75742_a(GlobalWaystones.class, DATA_NAME);
            if (instance == null) {
                instance = new GlobalWaystones();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }
        return new GlobalWaystones();
    }
}

