/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.GlobalWaystones;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.BlockWaystone;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportEffect;
import net.blay09.mods.waystones.network.message.MessageWaystones;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WaystoneManager {
    public static void sendPlayerWaystones(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PlayerWaystoneData waystoneData = PlayerWaystoneData.fromPlayer(player);
            NetworkHandler.channel.sendTo((IMessage)new MessageWaystones(waystoneData.getWaystones(), waystoneData.getLastFreeWarp(), waystoneData.getLastWarpStoneUse()), (EntityPlayerMP)player);
        }
    }

    public static void addPlayerWaystone(EntityPlayer player, WaystoneEntry waystone) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getOrCreateWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        tagList.func_74742_a((NBTBase)waystone.writeToNBT());
        tagCompound.func_74782_a("WaystoneList", (NBTBase)tagList);
    }

    public static boolean removePlayerWaystone(EntityPlayer player, WaystoneEntry waystone) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = tagList.func_150305_b(i);
            if (!WaystoneEntry.read(entryCompound).equals(waystone)) continue;
            tagList.func_74744_a(i);
            return true;
        }
        return false;
    }

    public static boolean checkAndUpdateWaystone(EntityPlayer player, WaystoneEntry waystone) {
        NBTTagCompound tagCompound = PlayerWaystoneHelper.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = tagList.func_150305_b(i);
            if (!WaystoneEntry.read(entryCompound).equals(waystone)) continue;
            TileWaystone tileEntity = WaystoneManager.getWaystoneInWorld(waystone);
            if (tileEntity != null) {
                if (!entryCompound.func_74779_i("Name").equals(tileEntity.getWaystoneName())) {
                    entryCompound.func_74778_a("Name", tileEntity.getWaystoneName());
                    WaystoneManager.sendPlayerWaystones(player);
                }
                return true;
            }
            if (waystone.isGlobal()) {
                GlobalWaystones.get(player.field_70170_p).removeGlobalWaystone(waystone);
            }
            WaystoneManager.removePlayerWaystone(player, waystone);
            WaystoneManager.sendPlayerWaystones(player);
            return false;
        }
        return false;
    }

    @Nullable
    public static TileWaystone getWaystoneInWorld(WaystoneEntry waystone) {
        TileEntity tileEntity;
        WorldServer targetWorld = DimensionManager.getWorld((int)waystone.getDimensionId());
        if (targetWorld == null) {
            DimensionManager.initDimension((int)waystone.getDimensionId());
            targetWorld = DimensionManager.getWorld((int)waystone.getDimensionId());
        }
        if (targetWorld != null && (tileEntity = targetWorld.func_175625_s(waystone.getPos())) instanceof TileWaystone) {
            return (TileWaystone)tileEntity;
        }
        return null;
    }

    public static boolean teleportToWaystone(EntityPlayer player, WaystoneEntry waystone) {
        MinecraftServer server;
        boolean dimensionWarp;
        if (!WaystoneManager.checkAndUpdateWaystone(player, waystone)) {
            TextComponentTranslation chatComponent = new TextComponentTranslation("waystones:waystoneBroken", new Object[0]);
            chatComponent.func_150256_b().func_150238_a(TextFormatting.RED);
            player.func_145747_a((ITextComponent)chatComponent);
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)waystone.getDimensionId());
        EnumFacing facing = (EnumFacing)targetWorld.func_180495_p(waystone.getPos()).func_177229_b((IProperty)BlockWaystone.FACING);
        BlockPos targetPos = waystone.getPos().func_177972_a(facing);
        boolean bl = dimensionWarp = waystone.getDimensionId() != player.func_130014_f_().field_73011_w.getDimension();
        if (!(!dimensionWarp || Waystones.getConfig().interDimension || waystone.isGlobal() && Waystones.getConfig().globalInterDimension)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("waystones:noDimensionWarp", new Object[0]));
            return false;
        }
        WaystoneManager.sendTeleportEffect(player.field_70170_p, new BlockPos((Entity)player));
        if (dimensionWarp && (server = player.field_70170_p.func_73046_m()) != null) {
            WaystoneManager.transferPlayerToDimension((EntityPlayerMP)player, waystone.getDimensionId(), server.func_184103_al());
        }
        player.field_70177_z = WaystoneManager.getRotationYaw(facing);
        player.func_70634_a((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5);
        WaystoneManager.sendTeleportEffect(player.field_70170_p, targetPos);
        return true;
    }

    private static void transferPlayerToDimension(EntityPlayerMP player, int dimension, PlayerList manager) {
        int oldDim = player.field_71093_bK;
        WorldServer oldWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer newWorld = manager.func_72365_p().func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        oldWorld.func_72973_f((Entity)player);
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        player.field_70128_L = false;
        WaystoneManager.transferEntityToWorld((Entity)player, oldWorld, newWorld);
        manager.func_72375_a(player, oldWorld);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        manager.func_72354_b(player, newWorld);
        manager.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    private static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        WorldProvider oldWorldProvider = oldWorld.field_73011_w;
        WorldProvider newWorldProvider = newWorld.field_73011_w;
        double moveFactor = oldWorldProvider.getMovementFactor() / newWorldProvider.getMovementFactor();
        double x = entity.field_70165_t * moveFactor;
        double z = entity.field_70161_v * moveFactor;
        oldWorld.field_72984_F.func_76320_a("placing");
        x = MathHelper.func_151237_a((double)x, (double)-2.9999872E7, (double)2.9999872E7);
        z = MathHelper.func_151237_a((double)z, (double)-2.9999872E7, (double)2.9999872E7);
        if (entity.func_70089_S()) {
            entity.func_70012_b(x, entity.field_70163_u, z, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        oldWorld.field_72984_F.func_76319_b();
        entity.func_70029_a((World)newWorld);
    }

    public static void sendTeleportEffect(World world, BlockPos pos) {
        NetworkHandler.channel.sendToAllAround((IMessage)new MessageTeleportEffect(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }

    public static float getRotationYaw(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }
}

