/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiButtonWaystoneEntry
extends GuiButton {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private final WaystoneEntry waystone;
    private final int xpLevelCost;

    public GuiButtonWaystoneEntry(int id, int x, int y, WaystoneEntry waystone, WarpMode mode) {
        super(id, x, y, (waystone.isGlobal() ? TextFormatting.YELLOW : "") + waystone.getName());
        this.waystone = waystone;
        EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
        boolean enableXPCost = mode != WarpMode.WARP_STONE || Waystones.getConfig().warpStoneXpCost;
        int n = this.xpLevelCost = enableXPCost && Waystones.getConfig().blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)((int)Math.sqrt(player.func_174831_c(waystone.getPos())) / Waystones.getConfig().blocksPerXPLevel), (int)0, (int)3) : 0;
        if (waystone.getDimensionId() != Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() && !Waystones.getConfig().interDimension && waystone.isGlobal() && Waystones.getConfig().globalInterDimension) {
            this.field_146124_l = false;
        }
        if (player.field_71068_ca < this.xpLevelCost) {
            this.field_146124_l = false;
        }
    }

    public WaystoneEntry getWaystone() {
        return this.waystone;
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        super.func_146112_a(mc, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.xpLevelCost > 0) {
            boolean canAfford = mc.field_71439_g.field_71068_ca >= this.xpLevelCost;
            mc.func_110434_K().func_110577_a(ENCHANTMENT_TABLE_GUI_TEXTURE);
            this.func_73729_b(this.field_146128_h + 2, this.field_146129_i + 2, (this.xpLevelCost - 1) * 16, 223 + (!canAfford ? 16 : 0), 16, 16);
            if (this.field_146123_n && mouseX <= this.field_146128_h + 16) {
                GuiUtils.drawHoveringText((List)Lists.newArrayList((Object[])new String[]{(canAfford ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_135052_a((String)"tooltip.waystones:levelRequirement", (Object[])new Object[]{this.xpLevelCost})}), (int)mouseX, (int)(mouseY + mc.field_71466_p.field_78288_b), (int)mc.field_71443_c, (int)mc.field_71440_d, (int)200, (FontRenderer)mc.field_71466_p);
            }
            GlStateManager.func_179140_f();
        }
    }
}

