/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WarpMode;
import net.blay09.mods.waystones.client.gui.GuiButtonSortWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonWaystoneEntry;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageSortWaystone;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class GuiWaystoneList
extends GuiScreen {
    private final WaystoneEntry[] entries;
    private final WarpMode warpMode;
    private final EnumHand hand;
    private final WaystoneEntry fromWaystone;
    private GuiButton btnPrevPage;
    private GuiButton btnNextPage;
    private int pageOffset;

    public GuiWaystoneList(WaystoneEntry[] entries, WarpMode warpMode, EnumHand hand, @Nullable WaystoneEntry fromWaystone) {
        this.entries = entries;
        this.warpMode = warpMode;
        this.hand = hand;
        this.fromWaystone = fromWaystone;
    }

    public void func_73866_w_() {
        this.btnPrevPage = new GuiButton(0, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.previousPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnPrevPage);
        this.btnNextPage = new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones:warpStone.nextPage", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnNextPage);
        this.updateList();
    }

    public void updateList() {
        int buttonsPerPage = 4;
        this.btnPrevPage.field_146124_l = this.pageOffset > 0;
        this.btnNextPage.field_146124_l = this.pageOffset < (this.entries.length - 1) / 4;
        Iterator it = this.field_146292_n.iterator();
        while (it.hasNext()) {
            GuiButton button = (GuiButton)it.next();
            if (!(button instanceof GuiButtonWaystoneEntry) && !(button instanceof GuiButtonSortWaystone)) continue;
            it.remove();
        }
        int id = 2;
        int y = 0;
        for (int i = 0; i < 4; ++i) {
            int entryIndex = this.pageOffset * 4 + i;
            if (entryIndex < 0 || entryIndex >= this.entries.length) continue;
            GuiButtonWaystoneEntry btnWaystone = new GuiButtonWaystoneEntry(id, this.field_146294_l / 2 - 100, this.field_146295_m / 2 - 60 + y, this.entries[entryIndex], this.warpMode);
            this.field_146292_n.add(btnWaystone);
            GuiButtonSortWaystone sortUp = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.field_146295_m / 2 - 60 + y + 2, btnWaystone, -1);
            if (entryIndex == 0) {
                sortUp.field_146125_m = false;
            }
            this.field_146292_n.add(sortUp);
            GuiButtonSortWaystone sortDown = new GuiButtonSortWaystone(++id, this.field_146294_l / 2 + 108, this.field_146295_m / 2 - 60 + y + 11, btnWaystone, 1);
            if (entryIndex == this.entries.length - 1) {
                sortDown.field_146125_m = false;
            }
            this.field_146292_n.add(sortDown);
            ++id;
            y += 22;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.btnNextPage) {
            ++this.pageOffset;
            this.updateList();
        } else if (button == this.btnPrevPage) {
            --this.pageOffset;
            this.updateList();
        } else if (button instanceof GuiButtonWaystoneEntry) {
            NetworkHandler.channel.sendToServer((IMessage)new MessageTeleportToWaystone(((GuiButtonWaystoneEntry)button).getWaystone(), this.warpMode, this.hand, this.fromWaystone));
            this.field_146297_k.func_147108_a(null);
        } else if (button instanceof GuiButtonSortWaystone) {
            WaystoneEntry waystoneEntry = ((GuiButtonSortWaystone)button).getWaystone();
            int index = ArrayUtils.indexOf((Object[])this.entries, (Object)waystoneEntry);
            int sortDir = ((GuiButtonSortWaystone)button).getSortDir();
            int otherIndex = index + sortDir;
            if (index == -1 || otherIndex < 0 || otherIndex >= this.entries.length) {
                return;
            }
            WaystoneEntry swap = this.entries[index];
            this.entries[index] = this.entries[otherIndex];
            this.entries[otherIndex] = swap;
            NetworkHandler.channel.sendToServer((IMessage)new MessageSortWaystone(index, otherIndex));
            this.updateList();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146270_b(0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiWaystoneList.func_73734_a((int)(this.field_146294_l / 2 - 50), (int)(this.field_146295_m / 2 - 50), (int)(this.field_146294_l / 2 + 50), (int)(this.field_146295_m / 2 + 50), (int)0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.waystones:warpStone.selectDestination", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 85, 0xFFFFFF);
        if (this.entries.length == 0) {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + I18n.func_135052_a((String)"waystones:scrollNotBound", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 20, 0xFFFFFF);
        }
    }
}

