/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.handler;

import javax.annotation.Nullable;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportToWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HandlerTeleportToWaystone
implements IMessageHandler<MessageTeleportToWaystone, IMessage> {
    @Nullable
    public IMessage onMessage(final MessageTeleportToWaystone message, final MessageContext ctx) {
        NetworkHandler.getThreadListener(ctx).func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                int dist = (int)Math.sqrt(player.func_174831_c(message.getWaystone().getPos()));
                int xpLevelCost = Waystones.getConfig().blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)(dist / Waystones.getConfig().blocksPerXPLevel), (int)0, (int)3) : 0;
                ItemStack heldItem = player.func_184586_b(message.getHand());
                switch (message.getWarpMode()) {
                    case INVENTORY_BUTTON: {
                        if (!Waystones.getConfig().teleportButtonReturnOnly && player.field_71068_ca < xpLevelCost) {
                            return;
                        }
                        if (Waystones.getConfig().teleportButton && !Waystones.getConfig().teleportButtonReturnOnly && PlayerWaystoneHelper.canFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b)) break;
                        return;
                    }
                    case WARP_SCROLL: {
                        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Waystones.itemWarpScroll) break;
                        return;
                    }
                    case WARP_STONE: {
                        if (Waystones.getConfig().warpStoneXpCost && player.field_71068_ca < xpLevelCost) {
                            return;
                        }
                        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Waystones.itemWarpStone) break;
                        return;
                    }
                    case WAYSTONE: {
                        if (player.field_71068_ca < xpLevelCost) {
                            return;
                        }
                        WaystoneEntry fromWaystone = message.getFromWaystone();
                        if (fromWaystone != null && WaystoneManager.getWaystoneInWorld(fromWaystone) != null) break;
                        return;
                    }
                }
                if (WaystoneManager.teleportToWaystone((EntityPlayer)ctx.getServerHandler().field_147369_b, message.getWaystone())) {
                    boolean shouldCooldown = !message.getWaystone().isGlobal() || !Waystones.getConfig().globalNoCooldown;
                    switch (message.getWarpMode()) {
                        case INVENTORY_BUTTON: {
                            if (shouldCooldown) {
                                PlayerWaystoneHelper.setLastFreeWarp((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                            }
                            player.func_71013_b(xpLevelCost);
                            break;
                        }
                        case WARP_SCROLL: {
                            heldItem.func_190918_g(1);
                            break;
                        }
                        case WARP_STONE: {
                            if (Waystones.getConfig().warpStoneXpCost) {
                                player.func_71013_b(xpLevelCost);
                            }
                            if (!shouldCooldown) break;
                            PlayerWaystoneHelper.setLastWarpStoneUse((EntityPlayer)ctx.getServerHandler().field_147369_b, System.currentTimeMillis());
                            break;
                        }
                        case WAYSTONE: {
                            player.func_71013_b(xpLevelCost);
                        }
                    }
                }
                WaystoneManager.sendPlayerWaystones((EntityPlayer)ctx.getServerHandler().field_147369_b);
            }
        });
        return null;
    }
}

