/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.worldgen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.blay09.mods.waystones.worldgen.RomanNumber;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class NameGenerator {
    private static final String[] random1 = new String[]{"Kr", "Ca", "Ra", "Rei", "Mar", "Luk", "Cro", "Cru", "Ray", "Bre", "Zed", "Mor", "Jag", "Mer", "Jar", "Mad", "Cry", "Zur", "Mjol", "Zork", "Creo", "Azak", "Azur", "Mrok", "Drak"};
    private static final String[] random2 = new String[]{"ir", "mi", "air", "sor", "mee", "clo", "red", "cra", "ark", "arc", "mur", "zer", "miri", "lori", "cres", "zoir", "urak", "marac", "slamar", "salmar"};
    private static final String[] random3 = new String[]{"d", "ed", "es", "er", "ark", "arc", "der", "med", "ure", "zur", "mur", "tron", "cred"};
    private static Map<String, String> SPECIAL_NAMES;
    private static Map<String, String> BIOME_NAMES;
    private static final Set<String> usedNames;

    private static String randomName(Random rand) {
        return random1[rand.nextInt(random1.length)] + random2[rand.nextInt(random2.length)] + random3[rand.nextInt(random3.length)];
    }

    public static void init() {
        SPECIAL_NAMES = Maps.newHashMap();
        BIOME_NAMES = Maps.newHashMap();
        NameGenerator.addSpecialName(Biomes.field_76787_r, "Dusty Beach");
        NameGenerator.addSpecialName(Biomes.field_76767_f, "Spectacular Forest");
        NameGenerator.addSpecialName(Biomes.field_76770_e, "Smart Hills");
        NameGenerator.addSpecialName(Biomes.field_76769_d, "Fiery Sands");
        NameGenerator.addSpecialName(Biomes.field_76771_b, "Dubzian Ocean");
        NameGenerator.addSpecialName(Biomes.field_76782_w, "Senroht Jungles");
        NameGenerator.addSpecialName(Biomes.field_76775_o, "Azra Mountain");
        NameGenerator.addSpecialName(Biomes.field_150589_Z, "Black Mesa");
        NameGenerator.addSpecialName(Biomes.field_76768_g, "Aisaka Taiga");
        NameGenerator.addSpecialName(Biomes.field_76780_h, "Darkon Swamps");
        NameGenerator.addSpecialName(Biomes.field_150578_U, "Foxglove Woods");
        NameGenerator.addSpecialName(Biomes.field_76786_s, "Medabi Desert");
        NameGenerator.addSpecialName(Biomes.field_150576_N, "Suton Beach");
        NameGenerator.addSpecialName(Biomes.field_150588_X, "Mystic's Sogen");
        NameGenerator.addSpecialName(Biomes.field_150582_Q, "Hizuru Bachi");
        NameGenerator.addSpecialName(Biomes.field_76774_n, "The Zero");
        NameGenerator.addSpecialName(Biomes.field_150585_R, "Moriyane");
        NameGenerator.addSpecialName(Biomes.field_185434_af, "The Movie");
        NameGenerator.addSpecialName(Biomes.field_76781_i, "Kawa River");
        NameGenerator.addSpecialName(Biomes.field_76789_p, "Hemara Island");
        NameGenerator.addSpecialName(Biomes.field_76772_c, "Orilis Plains");
        NameGenerator.addSpecialName(Biomes.field_150581_V, "Caeril");
        NameGenerator.addSpecialName(Biomes.field_180279_ad, "Maldor");
        NameGenerator.addSpecialName(Biomes.field_76779_k, "The Nocturne");
        NameGenerator.addSpecialName(Biomes.field_185440_P, "The Nihilus");
        NameGenerator.addBiomeName(Biomes.field_150584_S, "Taiga");
        NameGenerator.addBiomeName(Biomes.field_150578_U, "Taiga");
        NameGenerator.addBiomeName(Biomes.field_76768_g, "Taiga");
        NameGenerator.addBiomeName(Biomes.field_76772_c, "Plains");
        NameGenerator.addBiomeName(Biomes.field_76789_p, "Island");
        NameGenerator.addBiomeName(Biomes.field_76788_q, "Island");
        NameGenerator.addBiomeName(Biomes.field_76781_i, "River");
        NameGenerator.addBiomeName(Biomes.field_76777_m, "River");
        NameGenerator.addBiomeName(Biomes.field_76787_r, "Beach");
        NameGenerator.addBiomeName(Biomes.field_150577_O, "Beach");
        NameGenerator.addBiomeName(Biomes.field_150576_N, "Beach");
        NameGenerator.addBiomeName(Biomes.field_150583_P, "Forest");
        NameGenerator.addBiomeName(Biomes.field_150582_Q, "Forest");
        NameGenerator.addBiomeName(Biomes.field_76785_t, "Forest");
        NameGenerator.addBiomeName(Biomes.field_76767_f, "Forest");
        NameGenerator.addBiomeName(Biomes.field_150585_R, "Forest");
        NameGenerator.addBiomeName(Biomes.field_185444_T, "Forest");
        NameGenerator.addBiomeName(Biomes.field_185448_Z, "Forest");
        NameGenerator.addBiomeName(Biomes.field_185429_aa, "Forest");
        NameGenerator.addBiomeName(Biomes.field_185430_ab, "Forest");
        NameGenerator.addBiomeName(Biomes.field_150575_M, "Ocean");
        NameGenerator.addBiomeName(Biomes.field_76771_b, "Ocean");
        NameGenerator.addBiomeName(Biomes.field_76776_l, "Ocean");
        NameGenerator.addBiomeName(Biomes.field_76769_d, "Desert");
        NameGenerator.addBiomeName(Biomes.field_76786_s, "Desert");
        NameGenerator.addBiomeName(Biomes.field_185442_R, "Desert");
        NameGenerator.addBiomeName(Biomes.field_150579_T, "Hills");
        NameGenerator.addBiomeName(Biomes.field_76770_e, "Hills");
        NameGenerator.addBiomeName(Biomes.field_76783_v, "Hills");
        NameGenerator.addBiomeName(Biomes.field_150580_W, "Hills");
        NameGenerator.addBiomeName(Biomes.field_185443_S, "Hills");
        NameGenerator.addBiomeName(Biomes.field_185434_af, "Hills");
        NameGenerator.addBiomeName(Biomes.field_150581_V, "Hills");
        NameGenerator.addBiomeName(Biomes.field_76784_u, "Hills");
        NameGenerator.addBiomeName(Biomes.field_185433_ae, "Hills");
        NameGenerator.addBiomeName(Biomes.field_76780_h, "Swamps");
        NameGenerator.addBiomeName(Biomes.field_150599_m, "Swamps");
        NameGenerator.addBiomeName(Biomes.field_150588_X, "Savanna");
        NameGenerator.addBiomeName(Biomes.field_150587_Y, "Plateau");
        NameGenerator.addBiomeName(Biomes.field_185435_ag, "Savanna");
        NameGenerator.addBiomeName(Biomes.field_185436_ah, "Savanna");
        NameGenerator.addBiomeName(Biomes.field_76774_n, "Icelands");
        NameGenerator.addBiomeName(Biomes.field_76775_o, "Icelands");
        NameGenerator.addBiomeName(Biomes.field_185445_W, "Icelands");
        NameGenerator.addBiomeName(Biomes.field_76782_w, "Jungle");
        NameGenerator.addBiomeName(Biomes.field_150574_L, "Jungle");
        NameGenerator.addBiomeName(Biomes.field_76792_x, "Jungle");
        NameGenerator.addBiomeName(Biomes.field_185446_X, "Jungle");
        NameGenerator.addBiomeName(Biomes.field_185447_Y, "Jungle");
        NameGenerator.addBiomeName(Biomes.field_150607_aa, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_150589_Z, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_150608_ab, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_185437_ai, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_185439_ak, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_185438_aj, "Mesa");
        NameGenerator.addBiomeName(Biomes.field_185440_P, "Void");
        NameGenerator.addBiomeName(Biomes.field_76779_k, "Skies");
    }

    private static void addBiomeName(Biome biome, String name) {
        BIOME_NAMES.put(biome.func_185359_l(), name);
    }

    private static void addSpecialName(Biome biome, String name) {
        SPECIAL_NAMES.put(biome.func_185359_l(), name);
    }

    public static String getName(Biome biome, Random rand) {
        String name;
        if (SPECIAL_NAMES == null) {
            NameGenerator.init();
        }
        if ((name = SPECIAL_NAMES.get(biome.func_185359_l())) == null || usedNames.contains(name)) {
            String biomeSuffix = BIOME_NAMES.get(biome.func_185359_l());
            String tryName = name = NameGenerator.randomName(rand) + (biomeSuffix != null ? " " + biomeSuffix : "");
            int i = 1;
            while (usedNames.contains(tryName)) {
                tryName = name + " " + RomanNumber.toRoman(i);
                ++i;
            }
            name = tryName;
        }
        usedNames.add(name);
        return name;
    }

    static {
        usedNames = Sets.newHashSet();
    }
}

