/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.RemoveWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.SortWaystoneButton;
import net.blay09.mods.waystones.client.gui.widget.WaystoneButton;
import net.blay09.mods.waystones.container.WaystoneSelectionContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.RemoveWaystoneMessage;
import net.blay09.mods.waystones.network.message.RequestEditWaystoneMessage;
import net.blay09.mods.waystones.network.message.SelectWaystoneMessage;
import net.blay09.mods.waystones.network.message.SortWaystoneMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class WaystoneSelectionScreen
extends ContainerScreen<WaystoneSelectionContainer> {
    private final List<IWaystone> waystones;
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private Button btnPrevPage;
    private Button btnNextPage;
    private int pageOffset;
    private int headerY;
    private boolean isLocationHeaderHovered;
    private int buttonsPerPage;
    private static final int headerHeight = 40;
    private static final int footerHeight = 25;
    private static final int entryHeight = 25;

    public WaystoneSelectionScreen(WaystoneSelectionContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.waystones = PlayerWaystoneManager.getWaystones(playerInventory.field_70458_d);
        this.field_146999_f = 270;
        this.field_147000_g = 200;
    }

    public void init() {
        int maxContentHeight = (int)((float)this.height * 0.6f);
        int maxButtonsPerPage = (maxContentHeight - 40 - 25) / 25;
        this.buttonsPerPage = Math.max(4, Math.min(maxButtonsPerPage, this.waystones.size()));
        int contentHeight = 40 + this.buttonsPerPage * 25 + 25;
        this.field_146999_f = this.width;
        this.field_147000_g = contentHeight;
        super.init();
        this.tooltipProviders.clear();
        this.btnPrevPage = new Button(this.width / 2 - 100, this.height / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones.waystone_selection.previous_page", (Object[])new Object[0]), button -> {
            this.pageOffset = Screen.hasShiftDown() ? 0 : this.pageOffset - 1;
            this.updateList();
        });
        this.addButton(this.btnPrevPage);
        this.btnNextPage = new Button(this.width / 2 + 5, this.height / 2 + 40, 95, 20, I18n.func_135052_a((String)"gui.waystones.waystone_selection.next_page", (Object[])new Object[0]), button -> {
            this.pageOffset = Screen.hasShiftDown() ? (this.waystones.size() - 1) / this.buttonsPerPage : this.pageOffset + 1;
            this.updateList();
        });
        this.addButton(this.btnNextPage);
        this.updateList();
    }

    protected <T extends Widget> T addButton(T button) {
        if (button instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)button);
        }
        return (T)super.addButton(button);
    }

    private void updateList() {
        this.headerY = 0;
        this.btnPrevPage.active = this.pageOffset > 0;
        this.btnNextPage.active = this.pageOffset < (this.waystones.size() - 1) / this.buttonsPerPage;
        this.tooltipProviders.clear();
        this.buttons.removeIf(button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton);
        this.children.removeIf(button -> button instanceof WaystoneButton || button instanceof SortWaystoneButton || button instanceof RemoveWaystoneButton);
        int y = this.field_147009_r + 40 + this.headerY;
        for (int i = 0; i < this.buttonsPerPage; ++i) {
            int entryIndex = this.pageOffset * this.buttonsPerPage + i;
            if (entryIndex < 0 || entryIndex >= this.waystones.size()) continue;
            IWaystone waystone = this.waystones.get(entryIndex);
            this.addButton(this.createWaystoneButton(y, waystone));
            SortWaystoneButton sortUpButton = new SortWaystoneButton(this.width / 2 + 108, y + 2, -1, y, 20, it -> this.sortWaystone(entryIndex, -1));
            if (entryIndex == 0) {
                sortUpButton.active = false;
            }
            this.addButton(sortUpButton);
            SortWaystoneButton sortDownButton = new SortWaystoneButton(this.width / 2 + 108, y + 13, 1, y, 20, it -> this.sortWaystone(entryIndex, 1));
            if (entryIndex == this.waystones.size() - 1) {
                sortDownButton.active = false;
            }
            this.addButton(sortDownButton);
            RemoveWaystoneButton removeButton = new RemoveWaystoneButton(this.width / 2 + 122, y + 4, y, 20, button -> {
                PlayerWaystoneManager.deactivateWaystone((PlayerEntity)Minecraft.func_71410_x().field_71439_g, waystone);
                NetworkHandler.channel.sendToServer((Object)new RemoveWaystoneMessage(waystone));
                this.updateList();
            });
            if (!waystone.isGlobal()) {
                this.addButton(removeButton);
            }
            y += 22;
        }
        this.btnPrevPage.y = this.field_147009_r + this.headerY + 40 + this.buttonsPerPage * 22 + (this.waystones.size() > 0 ? 10 : 0);
        this.btnNextPage.y = this.field_147009_r + this.headerY + 40 + this.buttonsPerPage * 22 + (this.waystones.size() > 0 ? 10 : 0);
    }

    private WaystoneButton createWaystoneButton(int y, IWaystone waystone) {
        IWaystone waystoneFrom = ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom();
        WaystoneButton btnWaystone = new WaystoneButton(this.width / 2 - 100, y, waystone, ((WaystoneSelectionContainer)this.field_147002_h).getWarpMode(), button -> NetworkHandler.channel.sendToServer((Object)new SelectWaystoneMessage(waystone)));
        if (waystoneFrom != null && waystone.getWaystoneUid().equals(waystoneFrom.getWaystoneUid())) {
            btnWaystone.active = false;
        }
        return btnWaystone;
    }

    private void sortWaystone(int index, int sortDir) {
        int otherIndex;
        if (index < 0 || index >= this.waystones.size()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            otherIndex = sortDir == -1 ? -1 : this.waystones.size();
        } else {
            otherIndex = index + sortDir;
            if (otherIndex < 0 || otherIndex >= this.waystones.size()) {
                return;
            }
        }
        PlayerWaystoneManager.swapWaystoneSorting((PlayerEntity)Minecraft.func_71410_x().field_71439_g, index, otherIndex);
        NetworkHandler.channel.sendToServer((Object)new SortWaystoneMessage(index, otherIndex));
        this.updateList();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isLocationHeaderHovered && ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom() != null) {
            NetworkHandler.channel.sendToServer((Object)new RequestEditWaystoneMessage(((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom()));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            this.renderTooltip(tooltipProvider.getTooltip(), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IWaystone fromWaystone = ((WaystoneSelectionContainer)this.field_147002_h).getWaystoneFrom();
        this.drawCenteredString(fontRenderer, this.getTitle().func_150254_d(), this.field_146999_f / 2, this.headerY + (fromWaystone != null ? 20 : 0), 0xFFFFFF);
        if (fromWaystone != null) {
            this.drawLocationHeader(fromWaystone, mouseX, mouseY, this.field_146999_f / 2, this.headerY);
        }
        if (this.waystones.size() == 0) {
            this.drawCenteredString(fontRenderer, TextFormatting.RED + I18n.func_135052_a((String)"gui.waystones.waystone_selection.no_waystones_activated", (Object[])new Object[0]), this.field_146999_f / 2, this.height / 2 - 20, 0xFFFFFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawLocationHeader(IWaystone waystone, int mouseX, int mouseY, int x, int y) {
        fontRenderer = Minecraft.func_71410_x().field_71466_p;
        locationPrefix = TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.waystones.waystone_selection.current_location", (Object[])new Object[0]) + " ";
        locationPrefixWidth = fontRenderer.func_78256_a(locationPrefix);
        locationWidth = fontRenderer.func_78256_a(waystone.getName());
        fullWidth = locationPrefixWidth + locationWidth;
        startX = x - fullWidth / 2 + locationPrefixWidth;
        startY = y + this.field_147009_r;
        if (mouseX < startX || mouseX >= startX + locationWidth + 16 || mouseY < startY) ** GOTO lbl-1000
        fontRenderer.getClass();
        if (mouseY < startY + 9) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.isLocationHeaderHovered = v0;
        player = Minecraft.func_71410_x().field_71439_g;
        waystoneEditPermissions = PlayerWaystoneManager.mayEditWaystone((PlayerEntity)player, player.field_70170_p, waystone);
        fullText = locationPrefix + TextFormatting.WHITE;
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            fullText = fullText + TextFormatting.UNDERLINE;
        }
        fullText = fullText + waystone.getName();
        this.drawString(fontRenderer, TextFormatting.UNDERLINE + fullText, x - fullWidth / 2, y, 0xFFFFFF);
        if (this.isLocationHeaderHovered && waystoneEditPermissions == WaystoneEditPermissions.ALLOW) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)((float)x + (float)fullWidth / 2.0f + 4.0f), (double)y, (double)0.0);
            scale = 0.5f;
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(new ItemStack((IItemProvider)Items.field_151099_bA), 0, 0);
            GlStateManager.popMatrix();
        }
    }
}

