/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.container.WaystoneSettingsContainer;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.EditWaystoneMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class WaystoneSettingsScreen
extends ContainerScreen<WaystoneSettingsContainer> {
    private TextFieldWidget textField;
    private Button btnDone;
    private GuiCheckBox chkGlobal;

    public WaystoneSettingsScreen(WaystoneSettingsContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 270;
        this.field_147000_g = 200;
    }

    public void init() {
        this.field_146999_f = this.width;
        super.init();
        IWaystone waystone = ((WaystoneSettingsContainer)this.field_147002_h).getWaystone();
        String oldText = waystone.getName();
        if (this.textField != null) {
            oldText = this.textField.func_146179_b();
        }
        this.textField = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, this.width / 2 - 100, this.height / 2 - 20, 200, 20, this.textField, "");
        this.textField.func_146203_f(128);
        this.textField.func_146180_a(oldText);
        this.textField.changeFocus(true);
        this.addButton((Widget)this.textField);
        this.func_212928_a((IGuiEventListener)this.textField);
        this.btnDone = new Button(this.width / 2, this.height / 2 + 10, 100, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            if (this.textField.func_146179_b().isEmpty()) {
                this.textField.changeFocus(true);
                this.setFocused((IGuiEventListener)this.textField);
                return;
            }
            NetworkHandler.channel.sendToServer((Object)new EditWaystoneMessage(waystone, this.textField.func_146179_b(), this.chkGlobal.isChecked()));
        });
        this.addButton((Widget)this.btnDone);
        this.chkGlobal = new GuiCheckBox(this.width / 2 - 100, this.height / 2 + 15, " " + I18n.func_135052_a((String)"gui.waystones.waystone_settings.is_global", (Object[])new Object[0]), waystone.isGlobal());
        if (!PlayerWaystoneManager.mayEditGlobalWaystones((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.chkGlobal.visible = false;
        }
        this.addButton((Widget)this.chkGlobal);
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    public void removed() {
        super.removed();
        this.getMinecraft().field_195559_v.func_197967_a(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.textField.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.btnDone.onPress();
            return true;
        }
        if (this.textField.keyPressed(keyCode, scanCode, modifiers) || this.textField.isFocused()) {
            if (keyCode == 256) {
                this.getMinecraft().field_71439_g.func_71053_j();
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void tick() {
        this.textField.func_146178_a();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        Minecraft.func_71410_x().field_71466_p.func_211126_b(this.getTitle().func_150254_d(), (float)this.width / 2.0f - 100.0f, (float)this.height / 2.0f - 35.0f, 0xFFFFFF);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }
}

