/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class WaystoneButton
extends Button {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private final int xpLevelCost;

    public WaystoneButton(int x, int y, IWaystone waystone, WarpMode warpMode, Button.IPressable pressable) {
        super(x, y, 200, 20, (waystone.isGlobal() ? TextFormatting.YELLOW : "") + waystone.getName(), pressable);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.xpLevelCost = Math.round(PlayerWaystoneManager.getExperienceLevelCost((PlayerEntity)player, waystone, warpMode));
        if (!PlayerWaystoneManager.mayTeleportToWaystone((PlayerEntity)player, waystone)) {
            this.active = false;
        } else if (player.field_71068_ca < this.xpLevelCost && !player.field_71075_bZ.field_75098_d) {
            this.active = false;
        }
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        super.renderButton(mouseX, mouseY, partialTicks);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        if (this.xpLevelCost > 0) {
            boolean canAfford = mc.field_71439_g.field_71068_ca >= this.xpLevelCost || mc.field_71439_g.field_71075_bZ.field_75098_d;
            mc.func_110434_K().func_110577_a(ENCHANTMENT_TABLE_GUI_TEXTURE);
            this.blit(this.x + 2, this.y + 2, (Math.min(this.xpLevelCost, 3) - 1) * 16, 223 + (!canAfford ? 16 : 0), 16, 16);
            if (this.xpLevelCost > 3) {
                mc.field_71466_p.func_211126_b("+", (float)(this.x + 17), (float)(this.y + 6), 0xC8FF8F);
            }
            if (this.isHovered && mouseX <= this.x + 16) {
                ArrayList arrayList = Lists.newArrayList((Object[])new String[]{(canAfford ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_135052_a((String)"gui.waystones.waystone_selection.level_requirement", (Object[])new Object[]{this.xpLevelCost})});
                mc.field_71466_p.getClass();
                GuiUtils.drawHoveringText((List)arrayList, (int)mouseX, (int)(mouseY + 9), (int)mc.field_195558_d.func_198105_m(), (int)mc.field_195558_d.func_198083_n(), (int)200, (FontRenderer)mc.field_71466_p);
            }
            GlStateManager.disableLighting();
        }
    }
}

