/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import net.blay09.mods.waystones.config.WaystoneConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class WaystoneInventoryButton
extends Button {
    private static final ResourceLocation INVENTORY_BUTTON_TEXTURE = new ResourceLocation("waystones", "textures/gui/inventory_button.png");
    private final ContainerScreen<?> parentScreen;
    private final ItemStack iconItem;
    private final ItemStack iconItemHovered;

    public WaystoneInventoryButton(ContainerScreen<?> parentScreen, Button.IPressable pressable) {
        super(0, 0, 16, 16, "", pressable);
        this.parentScreen = parentScreen;
        this.iconItem = new ItemStack((IItemProvider)ModItems.boundScroll);
        this.iconItemHovered = new ItemStack((IItemProvider)ModItems.warpScroll);
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.x = this.parentScreen.getGuiLeft() + (Integer)WaystoneConfig.CLIENT.teleportButtonX.get();
            this.y = this.parentScreen.getGuiTop() + (Integer)WaystoneConfig.CLIENT.teleportButtonY.get();
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (PlayerWaystoneManager.canUseInventoryButton((PlayerEntity)player)) {
                ItemStack icon = this.isHovered ? this.iconItemHovered : this.iconItem;
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                itemRenderer.func_180450_b(icon, this.x, this.y);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(INVENTORY_BUTTON_TEXTURE);
                GlStateManager.enableBlend();
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                WaystoneInventoryButton.blit((int)this.x, (int)this.y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.disableBlend();
            }
        }
    }
}

