/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;

public class PersistentPlayerWaystoneData
implements IPlayerWaystoneData {
    private static final String TAG_NAME = "WaystonesData";
    private static final String ACTIVATED_WAYSTONES = "Waystones";
    private static final String INVENTORY_BUTTON_COOLDOWN_UNTIL = "InventoryButtonCooldownUntil";
    private static final String WARP_STONE_COOLDOWN_UNTIL = "WarpStoneCooldownUntil";

    @Override
    public void activateWaystone(PlayerEntity player, IWaystone waystone) {
        ListNBT activatedWaystonesData = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        activatedWaystonesData.add(0, (INBT)new StringNBT(waystone.getWaystoneUid().toString()));
    }

    @Override
    public boolean isWaystoneActivated(PlayerEntity player, IWaystone waystone) {
        ListNBT activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (INBT activatedWaystone : activatedWaystones) {
            if (!waystoneUid.equals(activatedWaystone.func_150285_a_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IWaystone> getWaystones(PlayerEntity player) {
        ListNBT activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        ArrayList<IWaystone> waystones = new ArrayList<IWaystone>();
        for (INBT activatedWaystone : activatedWaystones) {
            WaystoneProxy proxy = new WaystoneProxy(UUID.fromString(activatedWaystone.func_150285_a_()));
            if (!proxy.isValid()) continue;
            waystones.add(proxy);
        }
        return waystones;
    }

    @Override
    public void swapWaystoneSorting(PlayerEntity player, int index, int otherIndex) {
        ListNBT activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(PersistentPlayerWaystoneData.getWaystonesData(player));
        if (otherIndex == -1) {
            INBT waystone = activatedWaystones.remove(index);
            activatedWaystones.add(0, waystone);
        } else if (otherIndex == activatedWaystones.size()) {
            INBT waystone = activatedWaystones.remove(index);
            activatedWaystones.add((Object)waystone);
        } else {
            Collections.swap(activatedWaystones, index, otherIndex);
        }
    }

    @Override
    public void deactivateWaystone(PlayerEntity player, IWaystone waystone) {
        CompoundNBT data = PersistentPlayerWaystoneData.getWaystonesData(player);
        ListNBT activatedWaystones = PersistentPlayerWaystoneData.getActivatedWaystonesData(data);
        String waystoneUid = waystone.getWaystoneUid().toString();
        for (int i = activatedWaystones.size() - 1; i >= 0; --i) {
            INBT activatedWaystone = activatedWaystones.get(i);
            if (!waystoneUid.equals(activatedWaystone.func_150285_a_())) continue;
            activatedWaystones.remove(i);
            break;
        }
    }

    @Override
    public long getWarpStoneCooldownUntil(PlayerEntity player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).func_74763_f(WARP_STONE_COOLDOWN_UNTIL);
    }

    @Override
    public void setWarpStoneCooldownUntil(PlayerEntity player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).func_74772_a(WARP_STONE_COOLDOWN_UNTIL, timeStamp);
    }

    @Override
    public long getInventoryButtonCooldownUntil(PlayerEntity player) {
        return PersistentPlayerWaystoneData.getWaystonesData(player).func_74763_f(INVENTORY_BUTTON_COOLDOWN_UNTIL);
    }

    @Override
    public void setInventoryButtonCooldownUntil(PlayerEntity player, long timeStamp) {
        PersistentPlayerWaystoneData.getWaystonesData(player).func_74772_a(INVENTORY_BUTTON_COOLDOWN_UNTIL, timeStamp);
    }

    private static ListNBT getActivatedWaystonesData(CompoundNBT data) {
        ListNBT list = data.func_150295_c(ACTIVATED_WAYSTONES, 8);
        data.func_218657_a(ACTIVATED_WAYSTONES, (INBT)list);
        return list;
    }

    private static CompoundNBT getWaystonesData(PlayerEntity player) {
        CompoundNBT playerData = player.getPersistentData();
        CompoundNBT persistedData = playerData.func_74775_l("PlayerPersisted");
        CompoundNBT compound = persistedData.func_74775_l(TAG_NAME);
        persistedData.func_218657_a(TAG_NAME, (INBT)compound);
        playerData.func_218657_a("PlayerPersisted", (INBT)persistedData);
        return compound;
    }
}

